package com.mmc.pms.service;


import com.mmc.pms.common.ResultBody;
import com.mmc.pms.page.PageResult;

/**
 * @Author LW
 * @date 2023/3/14 13:26
 * 概要：
 */
public interface BrandManageService {

    /**
     * 添加品牌信息
     *
     * @param brandName 品牌名称
     * @return {@link ResultBody}
     */
    ResultBody addBrandInfo(String brandName);

    /**
     * 品牌列表信息
     *
     * @param pageNo   页面没有
     * @param pageSize 页面大小
     * @return {@link PageResult}
     */
    PageResult listBrandInfo(Integer pageNo, Integer pageSize);

//    /**
//     * 删除品牌信息
//     *
//     * @param id id
//     * @return {@link ResultBody}
//     */
//    ResultBody deleteBrandInfo(Integer id);

    /**
     * 编辑品牌信息
     *
     * @param id   id
     * @param name 名字
     * @return {@link ResultBody}
     */
    ResultBody editBrandInfo(Integer id, String name);
}
