package com.mmc.pms.model.vo;

import com.mmc.pms.model.dto.ProductInventoryVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 15:36 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IndustrySpecVO implements Serializable {
  private static final long serialVersionUID = 5939041792432691119L;

  @ApiModelProperty(value = "id")
  @NotNull(message = "修改时id不能为空", groups = Update.class)
  private Integer id;

  @NotNull(
      message = "行业sku的id不能为空",
      groups = {Update.class, Create.class})
  @ApiModelProperty(value = "行业sku的id")
  private Integer industrySkuId;

  @NotNull(
      message = "规格名称不能为空",
      groups = {Update.class, Create.class})
  @ApiModelProperty(value = "规格名称")
  private String specName;

  @NotNull(
      message = "规格图片不能为空",
      groups = {Update.class, Create.class})
  @ApiModelProperty(value = "规格图片")
  private String specImage;

  @NotNull(
      message = "产品清单不能为空",
      groups = {Update.class, Create.class})
  @ApiModelProperty(value = "产品清单")
  private List<ProductInventoryVO> productInventoryList;
}
