package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/25 10:00 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.dto.FlyerEntInfoDTO", description = "飞手机构DTO")
public class FlyerEntInfoDTO implements Serializable {
  private static final long serialVersionUID = -3064900348178903673L;

  @ApiModelProperty(value = "机构id")
  private Integer id;

  @ApiModelProperty(value = "飞手端用户id")
  private Integer flyerAccountId;

  @ApiModelProperty(value = "机构名称")
  private String entName;

  @ApiModelProperty(value = "机构认证审批状态")
  private Integer entCheckStatus;

  @ApiModelProperty(value = "机构法人名称")
  private String entLegalPerson;

  @ApiModelProperty(value = "社会统一信用码")
  private String uscCode;

  @ApiModelProperty(value = "营业执照url")
  private String unLicImg;

  @ApiModelProperty(value = "开户银行")
  private String bankName;

  @ApiModelProperty(value = "账户名称")
  private String accountHolder;

  @ApiModelProperty(value = "银行账号")
  private String bankAccount;

  @ApiModelProperty(value = "法人身份证号")
  private String idNumber;

  @ApiModelProperty(value = "机构备注")
  private String remark;

  @ApiModelProperty(value = "生成时间")
  private Date createTime;

  @ApiModelProperty(value = "更新时间")
  private Date updateTime;

  @ApiModelProperty(value = "飞手总数")
  private Integer sumOfFlyer;

  @ApiModelProperty(value = "认证飞手数")
  private Integer countOfAuthFlyer;

  @ApiModelProperty(value = "用户uid")
  private String uid;

  @ApiModelProperty(value = "用户手机号")
  private String phoneNum;

  @ApiModelProperty(value = "常驻城市")
  private String resAddress;

  @ApiModelProperty(value = "昵称")
  private String nickName;
}
