package com.mmc.pms.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.io.*;
import java.util.List;

/**
 * @Author small @Date 2023/5/23 13:50 @Version 1.0
 */
public class JsonUtil {

  public static void main(String[] args) {
    String array = "[1,24,23]";
    List<Integer> list = JSONArray.parseArray(array, Integer.class);
    System.out.println(list.get(2));
  }

  /**
   * 把Java对象转换成json字符串
   *
   * @param object 待转化为JSON字符串的Java对象
   * @return json 串 or null
   */
  public static String parseObjToJson(Object object) {
    String string = null;
    try {
      string = JSONObject.toJSONString(object);
    } catch (Exception e) {
      // LOGGER.error(e.getMessage());
    }
    return string;
  }

  /**
   * 将Json字符串信息转换成对应的Java对象
   *
   * @param json json字符串对象
   * @param c 对应的类型
   */
  public static <T> T parseJsonToObj(String json, Class<T> c) {
    try {
      JSONObject jsonObject = JSON.parseObject(json);
      return JSON.toJavaObject(jsonObject, c);
    } catch (Exception e) {
      // LOGGER.error(e.getMessage());
    }
    return null;
  }

  /**
   * 读取json文件
   *
   * @param fileName
   * @return
   */
  public static String readJsonFile(String fileName) {
    String jsonStr = "";
    try {
      File jsonFile = new File(fileName);
      FileReader fileReader = new FileReader(jsonFile);
      Reader reader = new InputStreamReader(new FileInputStream(jsonFile), "utf-8");
      int ch = 0;
      StringBuffer sb = new StringBuffer();
      while ((ch = reader.read()) != -1) {
        sb.append((char) ch);
      }
      fileReader.close();
      reader.close();
      jsonStr = sb.toString();
      return jsonStr;
    } catch (IOException e) {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * 将JSON数据格式化并保存到文件中
   *
   * @param jsonData 需要输出的json数
   * @param filePath 输出的文件地址
   * @return
   */
  public static boolean createJsonFile(Object jsonData, String filePath) {
    String content =
        JSON.toJSONString(
            jsonData,
            SerializerFeature.PrettyFormat,
            SerializerFeature.WriteMapNullValue,
            SerializerFeature.WriteDateUseDateFormat);
    // 标记文件生成是否成功
    boolean flag = true;
    // 生成json格式文件
    try {
      // 保证创建一个新文件
      File file = new File(filePath);
      if (!file.getParentFile().exists()) { // 如果父目录不存在，创建父目录
        file.getParentFile().mkdirs();
      }
      if (file.exists()) { // 如果已存在,删除旧文件
        file.delete();
      }
      file.createNewFile();
      // 将格式化后的字符串写入文件
      Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
      write.write(content);
      write.flush();
      write.close();
    } catch (Exception e) {
      flag = false;
      e.printStackTrace();
    }
    return flag;
  }
}
