package com.mmc.pms.entity;

import com.mmc.pms.model.dto.OrderInfoDTO;
import com.mmc.pms.model.vo.LeaseOrderVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small @Date 2023/5/25 10:05 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderInfoDO implements Serializable {
  private static final long serialVersionUID = 6544149196885009444L;
  private Integer id;
  private String orderNo;
  private Integer wareInfoId;
  private String wareNo;
  private String wareTitle;
  private String wareImg;
  private Integer skuInfoId;
  private String skuTitle;
  private Integer repoAccountId;
  private String uid;
  private String buyerName;
  private String buyerPhone;
  private BigDecimal unitPrice;
  private Integer wareNum;
  private BigDecimal shouldPay;
  private BigDecimal actualPay;
  private Integer orderType;
  private BigDecimal deposit;
  private BigDecimal rentPrice;
  private Date startDate;
  private Date endDate;
  private Integer payDay;
  private String tranStatus;
  private Integer exWare;
  private String remark;
  private String pfRemark;
  private String shutReason;
  private String payNo;
  private Date payTime;
  private Date sendWareTime;
  private Integer rcdCompanyId;
  private Date createTime;
  private Date updateTime;

  /**
   * 辅助字段
   *
   * @return
   */
  private OrderReceiptDO receipt;

  public OrderInfoDTO buildOrderInfoDTO() {
    return OrderInfoDTO.builder()
        .id(this.id)
        .orderNo(this.orderNo)
        .wareInfoId(this.wareInfoId)
        .wareNo(this.wareNo)
        .wareTitle(this.wareTitle)
        .skuInfoId(this.skuInfoId)
        .skuTitle(this.skuTitle)
        .repoAccountId(this.repoAccountId)
        .uid(this.uid)
        .buyerName(this.buyerName)
        .buyerPhone(this.buyerPhone)
        .unitPrice(this.unitPrice)
        .wareNum(this.wareNum)
        .shouldPay(this.shouldPay)
        .actualPay(this.actualPay)
        .orderType(this.orderType)
        .deposit(this.deposit)
        .rentPrice(this.rentPrice)
        .startDate(this.startDate)
        .endDate(this.endDate)
        .payDay(this.payDay)
        .tranStatus(this.tranStatus)
        .createTime(this.createTime)
        .payTime(this.payTime)
        .payNo(this.payNo)
        .wareImg(this.wareImg)
        .pfRemark(this.pfRemark)
        .shutReason(this.shutReason)
        .remark(this.remark)
        .receipt(this.receipt == null ? null : receipt.buildOrderReceiptDTO())
        .exWare(this.exWare)
        .sendWareTime(this.sendWareTime)
        .build();
  }

  public OrderInfoDO(LeaseOrderVO lease) {
    this.orderNo = lease.getOrderNo();
    this.wareInfoId = lease.getWareInfoId();
    this.wareNo = lease.getWareNo();
    this.wareTitle = lease.getWareTitle();
    this.wareImg = lease.getMainImg();
    this.skuInfoId = lease.getSkuInfoId();
    this.skuTitle = lease.getSkuTitle();
    this.repoAccountId = lease.getRepoAccountId();
    this.uid = lease.getUid();
    this.buyerName = lease.getBuyerName();
    this.buyerPhone = lease.getBuyerPhone();
    this.unitPrice = lease.getUnitPrice();
    this.wareNum = lease.getWareNum();
    this.shouldPay = lease.getShouldPay();
    this.actualPay = lease.getActualPay();
    this.orderType = lease.getOrderType();
    this.deposit = lease.getDeposit();
    this.rentPrice = lease.getRentPrice();
    this.startDate = lease.getStartDate();
    this.endDate = lease.getEndDate();
    this.payDay = lease.getPayDay();
    this.exWare = lease.getExWare();
    this.tranStatus = lease.getTranStatus();
    this.remark = lease.getRemark();
    this.createTime = lease.getCreateTime();
    this.rcdCompanyId = lease.getRcdCompanyId();
  }
}
