package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.vo.Create;
import com.mmc.pms.model.vo.GoodsAddVO;
import com.mmc.pms.model.vo.Update;
import com.mmc.pms.service.GoodsInfoService;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/3/14 13:22
 * 概要：
 */
@RestController
@RequestMapping("/goods")
@Api(tags = {"商品管理-相关接口"})
public class BackstageGoodsManageController {
    @Resource
    private GoodsInfoService goodsInfoService;

    @ApiOperation(value = "新增(租赁/销售)商品")
    @PostMapping("addGoodsInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addGoods(@ApiParam("商品信息VO") @Validated(Create.class) @RequestBody GoodsAddVO goodsAddVO) {
        return goodsInfoService.addGoods(goodsAddVO);
    }

    @ApiOperation(value = "修改(租赁/销售)商品")
    @PostMapping("editGoodsInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editGoodsInfo(@ApiParam("商品信息VO") @Validated(Update.class) @RequestBody GoodsAddVO goodsAddVO) {
        return goodsInfoService.editGoodsInfo(goodsAddVO);
    }
}
