/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemPropertiesHandler {
    private static final Pattern SYSPROP_PATTERN = Pattern.compile("systemProp\\.(.*)");

    public static Map<String, String> getSystemProperties(Path propertiesFile) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (!Files.isRegularFile(propertiesFile, new LinkOption[0])) {
            return propertyMap;
        }
        Properties properties = new Properties();
        try (InputStream inStream = Files.newInputStream(propertiesFile, new OpenOption[0]);){
            properties.load(inStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error when loading properties file=" + propertiesFile, e);
        }
        for (Map.Entry<Object, Object> entrySet : properties.entrySet()) {
            String key;
            Matcher matcher = SYSPROP_PATTERN.matcher(entrySet.getKey().toString());
            if (!matcher.find() || (key = matcher.group(1)).length() <= 0) continue;
            propertyMap.put(key, entrySet.getValue().toString());
        }
        return propertyMap;
    }
}

