package com.mmc.pms.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @Author small @Date 2023/5/16 13:35 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ClassifyInfoVO implements Serializable {
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    @Min(value = 1, groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "所属目录id")
    @NotNull(message = "所属目录id不能为空", groups = {Update.class, Create.class})
    private Integer directoryId;

    @ApiModelProperty(value = "分类名称", required = true)
    @Size(max = 15, message = "分类名称不能超过15个字", groups = {Update.class, Create.class})
    @NotBlank(message = "分类名称不能为空或空字符", groups = {Update.class, Create.class})
    private String classifyName;

    @ApiModelProperty(value = "pid:一级分类的pid是0 二级分类pid是一级分类id", required = true)
    @NotNull(message = "pid不能为空", groups = {Create.class, Update.class})
    private Integer pid;

    @ApiModelProperty(value = "描述")
    @Size(max = 70, message = "分类描述不能超过70个字", groups = {Update.class, Create.class})
    private String description;

    @ApiModelProperty(value = "icon图标")
    private String icon;

    @ApiModelProperty(value = "小程序底部备注")
    @Size(max = 150, message = "小程序底部备注不能超过150个字", groups = {Update.class, Create.class})
    private String remark;

    @ApiModelProperty(value = "分类所属模块id(0：通用分类 1：作业服务分类 2：设备租赁分类 3：飞手培训分类 4：产品商城分类)")
    @NotNull(message = "分类所属模块id不能为空", groups = {Update.class, Create.class})
    private Integer type;
}
