package com.mmc.pms.model.qo;

import com.mmc.pms.page.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small @Date 2023/5/16 9:55 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.qo.WareInfoQO", description = "model")
public class WareInfoQO implements Serializable {
  private static final long serialVersionUID = -2953141525621912414L;

  @ApiModelProperty(name = "id", value = "设备id", example = "1", required = false)
  private Integer id;

  @ApiModelProperty(name = "districtId", value = "地域id", example = "1", required = false)
  private Integer districtId;

  @ApiModelProperty(name = "categoryId", value = "类目id", example = "类目id")
  private Integer categoryId;

  @ApiModelProperty(name = "brandIdl", value = "品牌id", example = "品牌id")
  private Integer brandId;

  @ApiModelProperty(name = "modelId", value = "型号id", example = "型号id")
  private Integer modelId;
  /*@ApiModelProperty(value = "关键字")
  private String keyword;

  @ApiModelProperty(value = "商品状态，出租中或仓库中")
  private Integer wareStatus;

  @ApiModelProperty(value = "商品类型")
  private Integer wareTypeId;

  @ApiModelProperty(value = "活动属性")
  private Integer propInfoId;*/

  @ApiModelProperty(value = "页码", required = true)
  @NotNull(message = "页码不能为空", groups = Page.class)
  @Min(value = 1, groups = Page.class)
  private Integer pageNo;

  @ApiModelProperty(value = "每页显示数", required = true)
  @NotNull(message = "每页显示数不能为空", groups = Page.class)
  @Min(value = 1, groups = Page.class)
  private Integer pageSize;

  public void buildCurrentPage() {
    this.pageNo = (pageNo - 1) * pageSize;
  }
}
