package com.mmc.pms.entity;

import com.mmc.pms.model.dto.RepoCashDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;

/**
 * @Author small @Date 2023/5/25 9:48 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RepoCashDO implements Serializable {
  private static final long serialVersionUID = -7930603317037474755L;
  private Integer id;
  private Integer repoAccountId;
  private String uid;
  private String accountName;
  private Integer orderInfoId;
  private String orderNo;
  private Integer skuInfoId;
  private String skuTitle;
  private Integer wareInfoId;
  private String wareNo;
  private String wareTitle;
  private String payNo;
  private Integer payMethod;
  private BigDecimal amtPaid;
  private BigDecimal cashAmt;
  private Date payTime;
  private String refundNo;
  private String voucher;
  private String remark;
  private Integer createUser;
  private Date createTime;
  private Integer updateUser;
  private Date updateTime;

  public RepoCashDTO buildRepoCashDTO() {
    return RepoCashDTO.builder()
        .id(this.id)
        .repoAccountId(this.repoAccountId)
        .uid(this.uid)
        .accountName(this.accountName)
        .orderInfoId(this.orderInfoId)
        .orderNo(this.orderNo)
        .skuInfoId(this.skuInfoId)
        .skuTitle(this.skuTitle)
        .wareInfoId(this.wareInfoId)
        .wareNo(this.wareNo)
        .wareTitle(this.wareTitle)
        .payNo(this.payNo)
        .payMethod(this.payMethod)
        .amtPaid(this.amtPaid)
        .refundNo(this.refundNo)
        .createUser(this.createUser)
        .voucher(StringUtils.isBlank(this.voucher) ? null : Arrays.asList(this.voucher.split(",")))
        .cashAmt(this.cashAmt)
        .payTime(this.payTime)
        .remark(this.remark)
        .build();
  }
}
