package com.mmc.payment.model.vo.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author LW
 * @date 2023/7/19 16:20
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderRequestParamsVO implements Serializable {
    @ApiModelProperty(value = "订单编号")
    private String orderNo;
    @ApiModelProperty(value = "商品描述")
    private String description;
    @ApiModelProperty(value = "订单金额（分为单位）")
    private Integer amount;
    @ApiModelProperty(value = "订单来源 0：产品商城 1：租赁订单 2：培训订单 3：充值云享金 ...其他后续加")
    private Integer orderPort;
    @ApiModelProperty(value = "附加参数 :附加数据，在查询API和支付通知中原样返回，可作为自定义参数使用，实际情况下只有支付完成状态才会返回该字段。")
    private String attach;
    @ApiModelProperty(value = "聊天包类型id")
    private Integer chatType;
}

