package com.mmc.payment.model.vo.flyer;

import com.mmc.payment.common.publicinterface.Create;
import com.mmc.payment.common.publicinterface.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/29 16:14
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.EntFourValidateVO", description = "新增/修改参数类")
public class EntFourValidateVO implements Serializable {

    private static final long serialVersionUID = 6208245549679324962L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id创建修改不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "用户ID")
    @NotNull(message = "用户ID不能为空", groups = {Update.class, Create.class})
    private Integer userAccountId;
    @ApiModelProperty(value = "企业法人")
    @NotBlank(message = "企业法人", groups = {Create.class})
    private String entLegalPerson;
    @ApiModelProperty(value = "身份证号码", hidden = true)
    //@NotBlank(message = "身份证号码不能为空",groups = {Create.class})
    private String idNumber;
    @ApiModelProperty(value = "企业名称")
    @NotBlank(message = "企业名称", groups = {Update.class, Create.class})
    private String entName;
    @ApiModelProperty(value = "统一社会信用代码")
    @NotBlank(message = "统一社会信用代码", groups = {Create.class})
    private String unifySocialCreditCode;
    @ApiModelProperty(value = "营业执照")
    @NotBlank(message = "营业执照", groups = {Update.class})
    private String businessLicenseImg;
    @ApiModelProperty(value = "unionId")
    private String unionId;
    @ApiModelProperty(value = "参与邀请id")
    private Integer participateActivityId;

}

