package com.mmc.payment.model.vo.flyer;

import com.mmc.payment.common.publicinterface.Create;
import com.mmc.payment.common.publicinterface.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/29 16:16
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.FlyerAccountVO", description = "新增/修改参数类")
public class FlyerAccountVO implements Serializable {
    private static final long serialVersionUID = 5606965866344925637L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "更新时ID不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "uid")
    private String uid;
    @ApiModelProperty(value = "账号", example = "")
    @NotEmpty(message = "账号不能为空", groups = {Create.class})
    private String accountName;
    @ApiModelProperty(value = "飞手手机号")
    private String phoneNum;
    @ApiModelProperty(value = "账号类型", example = "个人飞手或机构")
    private Integer accountType;
    @ApiModelProperty(value = "飞手实名认证状态", example = "0未实名，1已实名")
    private Integer realAuthStatus;
    @ApiModelProperty(value = "机构认证状态", example = "0未认证，1，已认证")
    private Integer entAuthStatus;
    @ApiModelProperty(value = "工作状态，0休息中，1接单中，2服务订单中")
    private Integer workStatus;
    @ApiModelProperty(value = "昵称", example = "科比特")
    private String nickName;
    @ApiModelProperty(value = "常驻地址", example = "广东省深圳市")
    private String resAddress;
    @ApiModelProperty(value = "头像", example = "url")
    private String headerImg;
    @ApiModelProperty(value = "经度")
    private Double lon;
    @ApiModelProperty(value = "纬度")
    private Double lat;
    @ApiModelProperty(value = "用户备注")
    @Size(max = 70, message = "用户备注内容不能超过70字符", groups = {Update.class})
    private String remark;
    @ApiModelProperty(value = "用户删除状态，0未删除，1已删除")
    private Integer deleted;

}
