package com.mmc.payment.model.qo;

import com.mmc.payment.common.publicinterface.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/30 13:32
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.qo.RepoCashQO", description = "现金变更QO")
public class RepoWalletQO implements Serializable {
    private static final long serialVersionUID = 8705749845968042632L;
    @ApiModelProperty(value = "用户ID")
    private Integer repoAccountId;
    @ApiModelProperty(value = "现金余额")
    private String cashAmt;
    @ApiModelProperty(value = "已付现金")
    private String cashPaid;
    @ApiModelProperty(value = "已冻结现金")
    private String cashFreeze;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
