package com.mmc.payment.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @Author small
 * @Date 2023/5/24 10:03
 * @Version 1.0
 */
@Target(ElementType.METHOD) // 作用于方法上
@Retention(RetentionPolicy.RUNTIME) // 运行时
public @interface RepeatSubmit {

    /**
     * 设置请求锁定时间  默认5秒
     */
    long lockTime() default 5000L;

    /**
     * 当发生重复提交时候默认返回的错误信息
     */
    String errMsg() default "重复提交,请 second 秒后重试";

    /**
     * 是否允许lockTime时间内可以再次提交
     */
    boolean allowAgain() default true;
}
