package com.mmc.payment.common;

/**
 * @Author small
 * @Date 2023/5/23 19:30
 * @Version 1.0
 */
public class RedisConstant {
    /**
     * 验证码-key
     */
    public final static String VERIFYCODEKEY = "verifyCode";

    /**
     * 电话号码-key
     */
    public final static String PHONENUMKEY = "phoneNum";

    /**
     * 当天用户量统计-key
     */
    public final static String ACTIVE_USER_TOTAL_COUNT_TODAY = "active_user_total_count_today";

    /**
     * 后台-当天用户量统计-key
     */
    public final static String ADMIN_ACTIVE_COUNT_TODAY = "admin_active_count_today";

    /**
     * 云享飞-当天用户量统计-key
     */
    public final static String YXF_ACTIVE_COUNT_TODAY = "yxf_active_count_today";

    /**
     * 云飞手-当天用户量统计-key
     */
    public final static String YFS_ACTIVE_COUNT_TODAY = "yfs_active_count_today";

    /**
     * 云仓-当天用户量统计-key
     */
    public final static String YC_ACTIVE_COUNT_TODAY = "yc_active_count_today";

    /**
     * 登录信息token前缀
     */
    public final static String LOGING_TOKEN_BEFORE = "CLOUD-SHARED-FLIGHT-USERID@";

    /**
     * token黑名单-key
     *
     * @param userId
     * @return
     */

    /**
     * 实名认证 redis 的键
     */
    public final static String REALNAMEREDISKEY = "realName";

    /**
     * token失效
     */
    public final static String DISABLE_TOKEN = "DISABLE-TOKEN";

    /**
     * 分片上传的key
     *
     * @param userId
     * @return
     */
    public final static String PART_UPLOAD = "UPLOAD_PART_";

    /**
     * 飞手端-假数据-分页信息-可以
     */
    public final static String FLYER_DUMMY_DATA_PAGE = "FLYER_DUMMY_DATA_PAGE";

    /**
     * token失效列表的key
     */
    public final static String DISABLE_TOKEN_LIST = "DISABLE_TOKEN_LIST";

    /**
     * 无人机城的订单状态
     */
    public final static String UAV_MALL_ORDER_STATUS = "UAV_MALL_ORDER_STATUS";

    /**
     * 无人机城的快递公司编码
     */
    public final static String UAV_MALL_EXP_COM = "UAV_MALL_EXP_COM";

    /**
     * 无人机城的快递状态码
     */
    public final static String UAV_MALL_EXP_STATUS = "UAV_MALL_EXP_STATUS";

    /**
     * 微信access_token
     *
     * @param userId
     * @return
     */
    public final static String WX_ACCESS_TOKEN_BEFORE = "WX_ACCESS_TOKEN_";

    public final static String REPO_SEND_PAY_MESSAGE = "REPO_ORDER_REMIND_PAY_";

    public final static String FLYER_PUBLIC_DEFAULT_NAME = "FLYER_PUBLIC_DEFAULT_NAME";

    public final static String EVALUATION = "EVALUATION";

    public final static String FLYER_DUMMY_DATA="FLYER_DUMMY_DATA_KEY";

    public final static String UAV_DUMMY_DATA="UAV_DUMMY_DATA_KEY";

    /**
     * tagInfoAllot表的缓存key
     */
    public final static String TAGINFOALLOT_QUESTALL = "csf-service-system:tagInfoAllot:questAll";

    public static String getDisableTokenKey(String accountId, String roleId, String tokenType) {
        StringBuffer key = new StringBuffer();
        key.append(RedisConstant.DISABLE_TOKEN);
        key.append("_ROLE_");
        key.append(roleId);
        key.append("_");
        key.append(accountId);
        return key.toString();
    }

    /**
     * 生成唯一的分片上传key
     *
     * @param uploadId
     * @return
     */
    public static String createPartUploadKey(String uploadId) {
        StringBuffer key = new StringBuffer();
        key.append(uploadId);
        return key.toString();
    }

    /**
     * 生成微信api的access_token的key
     */
    public static String createWxToken(String wxAppid) {
        StringBuffer key = new StringBuffer();
        key.append(RedisConstant.WX_ACCESS_TOKEN_BEFORE);
        key.append(wxAppid);
        return key.toString();
    }

    /**
     * 表单重复提交key
     */
    public static String createRepeatKey(String token, String url, String params) {
        StringBuffer key = new StringBuffer();
        key.append(token);
        key.append(url);
        key.append(params);
        return key.toString();
    }

    public static String createRepeatKey(String token, String url) {
        return RedisConstant.createRepeatKey(token, url, "");
    }

    /**
     * 登录缓存信息
     */
    public static String createLoginCacheKey(String tokenType, Integer id) {
        StringBuffer key = new StringBuffer();
        key.append(tokenType);
        key.append("_");
        key.append(id);
        return key.toString();
    }

    /**
     * 每位账号的的token的key的前缀
     */
    public static String tokenPreFix(String tokenType, String roleId) {
        StringBuffer key = new StringBuffer();
        key.append(tokenType);
        key.append("_ROLE_");
        key.append(roleId);
        key.append("_");
        return key.toString();
    }

    /**
     * 每位账号的token保存的key
     */
    public static String createLoginTokenKey(String tokenType, String roleId, String accountId) {
        StringBuffer key = new StringBuffer();
        key.append(RedisConstant.tokenPreFix(tokenType, roleId));
        key.append(accountId);
        return key.toString();
    }

    public static String createRepoOrderOver(Integer orderInfoId) {
        StringBuffer key = new StringBuffer();
        key.append(RedisConstant.REPO_SEND_PAY_MESSAGE);
        key.append(orderInfoId);
        return key.toString();
    }

    public static String getLockKey(String userId, String tokenType, String path) {
        StringBuffer sb = new StringBuffer();
        sb.append(userId);
        sb.append("_");
        sb.append(tokenType);
        sb.append("_");
        sb.append(path);
        return sb.toString();
    }

    public static String createInspection(Integer id) {
        StringBuffer key = new StringBuffer();
        key.append(RedisConstant.EVALUATION);
        key.append(id);
        return key.toString();
    }

    public static String accessTokenKey(String clientId, Integer roleId, String grantType) {
        StringBuilder key = new StringBuilder();
        key.append("OAUTH_");
        key.append(clientId);
        key.append("_");
        key.append(roleId);
        key.append("_");
        key.append(grantType);
        return key.toString();
    }

    public static String getCompanyChildKey(Integer companyId){
        StringBuilder key = new StringBuilder();
        key.append("company_cache:");
        key.append(companyId);
        return key.toString();
    }

    public static String getXEAccessTokenKey(){
        StringBuilder key = new StringBuilder();
        key.append("XE_ACCESS_TOKEN");
        return key.toString();
    }
}
