package com.mmc.payment.mq.impl;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.payment.model.vo.wallet.TopUpOrderVO;
import com.mmc.payment.mq.PublishMsg;
import com.mmc.payment.mq.constant.RabbitmqConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author LW
 * @date 2023/8/23 13:42
 * 概要：
 */
@Slf4j
@Service
public class PublishMsgImpl implements PublishMsg {
    @Autowired
    RabbitTemplate rabbitTemplate;

    @Override
    public void sendNewTopUpOrder(TopUpOrderVO topUpOrder, String routingKey) {
        log.info("############云享飞pro-充值订单-RabbitMQ-Send-##########");
        log.info("sendNewTopUpOrder:{},routingKey:{}", JSONObject.toJSONString(topUpOrder), routingKey);
        rabbitTemplate.convertAndSend(RabbitmqConstant.USER_TOP_UP_DIRECT_EXCHANGE, routingKey, JSONObject.toJSONString(topUpOrder));
    }

    @Override
    public void sendPayUavOrder(TopUpOrderVO topUpOrderVO, String routingKey) {
        log.info("############云享飞pro-商城订单支付-RabbitMQ-Send-##########");
        log.info("sendPayUavOrder:{},routingKey:{}", JSONObject.toJSONString(topUpOrderVO), routingKey);
        rabbitTemplate.convertAndSend(RabbitmqConstant.USER_TOP_UP_DIRECT_EXCHANGE, routingKey, JSONObject.toJSONString(topUpOrderVO));
    }
}
