package com.mmc.payment.dao;

import com.mmc.payment.entity.cash.CashTypeDO;
import com.mmc.payment.entity.repo.RepoCashDO;
import com.mmc.payment.entity.repo.RepoWalletDO;
import com.mmc.payment.model.qo.RepoCashQO;
import com.mmc.payment.model.qo.UserCashQO;
import com.mmc.payment.model.qo.WalletUsersQO;
import org.apache.ibatis.annotations.Mapper;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small @Date 2023/5/24 10:10 @Version 1.0
 */
@Mapper
public interface RepoCashDao {
    RepoCashDO getRefundCashInfo(String refundNo);

    void insertRepoCash(RepoCashDO rc);

    void updateCashRemark(Integer id, String remark);

    List<RepoCashDO> listPagePFRepoCash(RepoCashQO param);

    int countPagePFRepoCash(RepoCashQO param);

    RepoWalletDO getRepoWalletInfo(Integer repoAccountId);

    void updateRepoWalletAmt(Integer repoAccountId, BigDecimal chageAmt);

    BigDecimal RemainingBalance(Integer repoAccountId);

    void updateWalletAmt(Integer repoAccountId, BigDecimal addAmt, BigDecimal addPaid);

    void orderPayment(RepoCashDO repoCashDO);

    int countPagePayManager(UserCashQO param);

    List<RepoWalletDO> listPagePayManager(UserCashQO param);

    List<RepoWalletDO> listWalletInfo(UserCashQO param);

    void walletUsers(WalletUsersQO properties);

    Integer findWalletUsers(WalletUsersQO properties);

    List<CashTypeDO> cashType();

    RepoWalletDO userWallet(Integer userAccountId);
}
