package com.mmc.payment.controller;

import com.mmc.payment.common.result.ResultBody;
import com.mmc.payment.model.vo.order.ApplyRefundVO;
import com.mmc.payment.model.vo.order.OrderRequestParamsVO;
import com.mmc.payment.model.vo.order.UserPayInfoVO;
import com.mmc.payment.service.WechatPayService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;

/**
 * @Author LW
 * @date 2023/7/19 14:26
 * 概要：
 */
@Api(tags = {"微信支付-相关接口"})
@RestController
@RequestMapping("/wechat/")
public class WechatPayController extends BaseController {
    @Resource
    WechatPayService wechatPayService;

    @ApiOperation(value = "小程序调起支付API")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("pay")
    public Map orderPay(@RequestBody OrderRequestParamsVO orderRequestParamsVO, HttpServletRequest request) throws IOException {
        return wechatPayService.orderPay(orderRequestParamsVO, this.getUserLoginInfoFromRedis(request).getUserAccountId(), request);
    }

    @ApiOperation(value = "支付异步通知")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("payCallback")
    public Map payCallback(HttpServletRequest request) {
        return wechatPayService.payCallback(request);
    }

    @ApiOperation(value = "关闭订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("closeOrder")
    public ResultBody closeOrder(String orderNo) {
        return wechatPayService.closeOrder(orderNo);
    }

    @ApiOperation(value = "根据交易号或订单编号查询订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("queryOrder")
    public ResultBody queryOrder(@RequestParam(required = false) String transactionId,
                                 @RequestParam(required = false) String orderNo) {
        return wechatPayService.queryOrder(transactionId, orderNo);
    }

    @ApiOperation(value = "申请退款")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("applyRefund")
    public ResultBody applyRefund(@RequestBody ApplyRefundVO applyRefundVO) {
        return wechatPayService.applyRefund(applyRefundVO);
    }

    @ApiOperation(value = "退款异步通知")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("refundCallback")
    public Map refundCallback(HttpServletRequest request) {
        return wechatPayService.refundCallback(request);
    }

    @ApiOperation(value = "查询退款")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("queryRefund")
    public ResultBody queryRefund(String outRefundNo) {
        return wechatPayService.queryRefund(outRefundNo);
    }

    @ApiOperation(value = "订单编号查询订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserPayInfoVO.class)})
    @GetMapping("queryUserPayInfo")
    public UserPayInfoVO queryUserPayInfo(@RequestParam(required = false) String orderNo) {
        return wechatPayService.queryUserPayInfo(orderNo);
    }

}
