package com.mmc.payment.model.vo.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author LW
 * @date 2023/7/19 16:20
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderRequestParamsVO implements Serializable {
    @ApiModelProperty(value = "订单编号")
    private String orderNo;
    @ApiModelProperty(value = "商品描述")
    private String description;
    @ApiModelProperty(value = "订单金额（分为单位）")
    private Integer amount;
    @ApiModelProperty(value = "订单来源 0：产品商城 1：租赁订单 2：培训订单 ...其他后续加")
    private Integer orderPort;
}

