package com.mmc.payment.util;

import com.mmc.payment.constant.UserSystemConstant;
import com.mmc.payment.constant.WechatConstant;
import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.RSAAutoCertificateConfig;
import com.wechat.pay.java.core.notification.NotificationConfig;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/7/20 10:36
 * 概要：
 */
@Component
public class WxConfigUtils {
    @Resource
    UserSystemConstant userSystemConstant;

    public Config createConfig() {
        // 使用自动更新平台证书的RSA配置
        // 一个商户号只能初始化一个配置，否则会因为重复的下载任务报错
        Config config =
                new RSAAutoCertificateConfig.Builder()
                        .merchantId(userSystemConstant.getMchid())
                        .privateKeyFromPath(WechatConstant.privateKeyPath)
                        .merchantSerialNumber(userSystemConstant.getMchNumber())
                        .apiV3Key(userSystemConstant.getApiv3Key())
                        .build();

        return config;
    }

    public NotificationConfig createNotificationConfig() {
        // 使用自动更新平台证书的RSA配置
        // 一个商户号只能初始化一个配置，否则会因为重复的下载任务报错
        NotificationConfig config =
                new RSAAutoCertificateConfig.Builder()
                        .merchantId(userSystemConstant.getMchid())
                        .privateKeyFromPath(WechatConstant.privateKeyPath)
                        .merchantSerialNumber(userSystemConstant.getMchNumber())
                        .apiV3Key(userSystemConstant.getApiv3Key())
                        .build();

        return config;
    }
}
