package com.mmc.payment.service.Impl;

import cn.hutool.core.util.RandomUtil;
import com.mmc.payment.constant.UserSystemConstant;
import com.mmc.payment.dao.WechatPayDao;
import com.mmc.payment.entity.order.WxPrepayLogDO;
import com.mmc.payment.feign.UserAppApi;
import com.mmc.payment.model.dto.user.UserAccountSimpleDTO;
import com.mmc.payment.model.vo.order.OrderRequestParamsVO;
import com.mmc.payment.service.WechatPayService;
import com.mmc.payment.util.WxConfigUtils;
import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.SignatureResult;
import com.wechat.pay.java.core.notification.NotificationConfig;
import com.wechat.pay.java.core.notification.NotificationParser;
import com.wechat.pay.java.core.notification.RequestParam;
import com.wechat.pay.java.service.partnerpayments.jsapi.model.Transaction;
import com.wechat.pay.java.service.payments.jsapi.JsapiService;
import com.wechat.pay.java.service.payments.jsapi.model.Amount;
import com.wechat.pay.java.service.payments.jsapi.model.Payer;
import com.wechat.pay.java.service.payments.jsapi.model.PrepayRequest;
import com.wechat.pay.java.service.payments.jsapi.model.PrepayResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author LW
 * @date 2023/7/19 16:56
 * 概要：
 */
@Service
@Slf4j
public class WechatPayServiceImpl implements WechatPayService {
    @Resource
    UserSystemConstant userSystemConstant;
    @Resource
    WechatPayDao wechatPayDao;
    @Resource
    UserAppApi userAppApi;
    @Resource
    WxConfigUtils wxConfigUtils;

    @Override
    public Map orderPay(OrderRequestParamsVO orderRequestParamsVO, Integer userAccountId, HttpServletRequest request) {
        UserAccountSimpleDTO userSimpleInfo = userAppApi.feignGetUserSimpleInfo(userAccountId, request.getHeader("token"));
        if (userSimpleInfo == null) {
            throw new RuntimeException("服务器内部错误！");
        }
        Config config = wxConfigUtils.createConfig();
        // 构建service
        JsapiService jsapiService = new JsapiService.Builder().config(config).build();
        // request.setXxx(val)设置所需参数，具体参数可见Request定义
        PrepayRequest prepayRequest = new PrepayRequest();
        Amount amount = new Amount();
        amount.setTotal(orderRequestParamsVO.getAmount());
        prepayRequest.setAmount(amount);
        Payer payer = new Payer();
        prepayRequest.setPayer(payer);
        payer.setOpenid(userSimpleInfo.getOpenid());
        prepayRequest.setAppid(userSystemConstant.getWxAppId());
        prepayRequest.setMchid(userSystemConstant.getMchid());
        prepayRequest.setDescription(orderRequestParamsVO.getDescription());
        prepayRequest.setNotifyUrl(userSystemConstant.getNotifyUrl());
        prepayRequest.setOutTradeNo(orderRequestParamsVO.getOrderNo());
        // 调用下单方法，得到应答
        PrepayResponse prepay = jsapiService.prepay(prepayRequest);
        String prepayId = prepay.getPrepayId();
        WxPrepayLogDO wxPrepayLogDO = new WxPrepayLogDO();
        wxPrepayLogDO.setOrderPort(orderRequestParamsVO.getOrderPort());
        wxPrepayLogDO.setOrderNo(orderRequestParamsVO.getOrderNo());
        wxPrepayLogDO.setDescription(orderRequestParamsVO.getDescription());
        wxPrepayLogDO.setUserAccountId(userAccountId);
        wxPrepayLogDO.setAmount(orderRequestParamsVO.getAmount());
        wxPrepayLogDO.setPrepayId(prepayId);
        wxPrepayLogDO.setOpenId(userSimpleInfo.getOpenid());
        // 往数据库插入下单的日志信息
        wechatPayDao.insertWxPrepayLog(wxPrepayLogDO);
        // 获取时间戳
        String timeStamp = System.currentTimeMillis() / 1000 + "";
        // 获取随机字符串
        String nonceStr = RandomUtil.randomString(32);
        // 签名方式
        String signType = "RSA";
        // 订单详情扩展字符串
        String prepayPackage = "prepay_id=" + prepayId;
        // 构造签名串
        StringBuilder sb = new StringBuilder();
        sb.append(userSystemConstant.getWxAppId()).append("\n");
        sb.append(timeStamp).append("\n");
        sb.append(nonceStr).append("\n");
        sb.append(prepayPackage).append("\n");
        // 生成签名
        SignatureResult sign = config.createSigner().sign(sb.toString());
        Map<String, Object> map = new HashMap<>(16);
        map.put("timeStamp", timeStamp);
        map.put("nonceStr", nonceStr);
        map.put("package", prepayPackage);
        map.put("signType", signType);
        map.put("paySign", sign);
        return map;
    }

    @Override
    public Map payCallback(HttpServletRequest request) {
        Map<String, String> result = new HashMap(16);
        result.put("code", "FAIL");
        // 获取应答时间戳
        String timestamp = request.getHeader("Wechatpay-Timestamp");
        // 获取应答随机串
        String nonce = request.getHeader("Wechatpay-Nonce");
        // 获取应答签名
        String signature = request.getHeader("Wechatpay-Signature");
        // 获取应答序列号
        String serialNumber = request.getHeader("Wechatpay-Serial");
        log.info("应答时间戳: {},应答随机串:{},应答签名:{},应答序列号{}", timestamp, nonce, signature, serialNumber);
        try {
            // 获取body请求报文
            BufferedReader br = request.getReader();
            String str = null;
            StringBuilder sb = new StringBuilder();
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            log.info("请求体数据：{}", sb);
            NotificationConfig config = wxConfigUtils.createNotificationConfig();
            // 构造 RequestParam
            RequestParam requestParam = new RequestParam.Builder()
                    .serialNumber(serialNumber)
                    .nonce(nonce)
                    .signature(signature)
                    .timestamp(timestamp)
                    .body(sb.toString())
                    .build();
            // 初始化 NotificationParser
            NotificationParser parser = new NotificationParser(config);
            // 以支付通知回调为例，验签、解密并转换成 Transaction
            Transaction transaction = parser.parse(requestParam, Transaction.class);
            log.info("解密resource数据：{}", transaction);
            result.put("code", "SUCCESS");
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}
