package com.mmc.payment.mq.config;

import com.mmc.payment.mq.constant.RabbitmqConstant;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author: lw
 * @Date: 2023/8/23 11:26
 */
@Configuration
public class DirectExchangeConfig {
    @Bean
    public DirectExchange directExchange() {
        return new DirectExchange(RabbitmqConstant.USER_TOP_UP_DIRECT_EXCHANGE);
    }

    @Bean
    public Queue directQueue1() {
        return new Queue(RabbitmqConstant.USER_TOP_UP_DIRECT_QUEUE, true);
    }

    @Bean
    public Binding bindingDirect1() {
        Binding binding = BindingBuilder.bind(directQueue1()).to(directExchange()).with(RabbitmqConstant.USER_TOP_UP_ROUTING_KEY);
        return binding;
    }

    @Bean
    public Queue directQueue2() {
        return new Queue(RabbitmqConstant.USER_TOP_UP_SUCCESS_QUEUE, true);
    }

    @Bean
    public Binding bindingDirect2() {
        Binding binding = BindingBuilder.bind(directQueue2()).to(directExchange()).with(RabbitmqConstant.USER_TOP_UP_SUCCESS_ROUTING_KEY);
        return binding;
    }
}
