package com.mmc.payment.mq.config;

import com.mmc.payment.mq.constant.RabbitmqConstant;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author: lw
 * @Date: 2023/8/23 11:26
 */
@Configuration
public class DirectExchangeConfig {
    @Bean
    public DirectExchange directExchange() {
        return new DirectExchange(RabbitmqConstant.USER_TOP_UP_DIRECT_EXCHANGE);
    }

    @Bean
    public Queue directQueue() {
        return new Queue(RabbitmqConstant.USER_TOP_UP_DIRECT_QUEUE, true);
    }

    @Bean
    public Binding bindingDirect() {
        Binding binding = BindingBuilder.bind(directQueue()).to(directExchange()).with(RabbitmqConstant.USER_TOP_UP_ROUTING_KEY);
        return binding;
    }


}
