package com.mmc.payment.model.vo.repo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.ibatis.annotations.Update;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/23 19:39
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.RepoAccountVO", description = "微信用户信息修改VO")
public class RepoAccountVO implements Serializable {
    private static final long serialVersionUID = -2060063935512185318L;
    @ApiModelProperty(value = "repoAccountId")
    @NotNull(message = "repoAccountId不能为空", groups = Update.class)
    private Integer id;
    @ApiModelProperty(value = "nickName")
    private String nickName;
    @ApiModelProperty(value = "常驻地址")
    private String resAddress;
    @ApiModelProperty(value = "经度")
    private BigDecimal lon;
    @ApiModelProperty(value = "纬度")
    private BigDecimal lat;
    @ApiModelProperty(value = "头像")
    private String headerImg;
}
