package com.mmc.payment.entity.flyer;

import com.mmc.payment.model.dto.flyer.FlyerEntInfoDTO;
import com.mmc.payment.model.vo.flyer.EntFourValidateVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/29 16:12
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FlyerEntInfoDO implements Serializable {
    private static final long serialVersionUID = -3400952137664644676L;
    private Integer id;
    private Integer flyerAccountId;
    private String entName;
    private Integer entCheckStatus;
    private String entLegalPerson;
    private String uscCode;
    private String unLicImg;
    private String bankName;
    private String accountHolder;
    private String bankAccount;
    private String idNumber;
    private String remark;
    private Date createTime;
    private Date updateTime;

    /**
     * 额外字段
     */
    private Integer sumOfFlyer;
    private Integer countOfAuthFlyer;
    private String uid;
    private String phoneNum;
    private String resAddress;
    private String nickName;

    public FlyerEntInfoDTO buildFlyerEntInfoDTO() {
        return FlyerEntInfoDTO.builder().id(this.id).uid(this.uid).phoneNum(this.phoneNum).resAddress(this.resAddress).nickName(this.nickName)
                .flyerAccountId(this.flyerAccountId).entName(this.entName).entCheckStatus(this.entCheckStatus).entLegalPerson(this.entLegalPerson)
                .uscCode(this.uscCode).unLicImg(this.unLicImg).bankName(this.bankName).accountHolder(this.accountHolder).bankAccount(this.bankAccount)
                .idNumber(this.idNumber).remark(this.remark).createTime(this.createTime).updateTime(this.updateTime).sumOfFlyer(this.sumOfFlyer)
                .countOfAuthFlyer(this.countOfAuthFlyer).build();
    }

    public FlyerEntInfoDO(EntFourValidateVO entFourValidateVO) {
        this.flyerAccountId = entFourValidateVO.getUserAccountId();
        this.entLegalPerson = entFourValidateVO.getEntLegalPerson();
        this.entName = entFourValidateVO.getEntName();
        this.uscCode = entFourValidateVO.getUnifySocialCreditCode();
        this.unLicImg = entFourValidateVO.getBusinessLicenseImg();
        this.idNumber = entFourValidateVO.getIdNumber();
    }
}
