package com.mmc.payment.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mmc.payment.common.PortTypeEnum;
import com.mmc.payment.common.result.PageResult;
import com.mmc.payment.common.result.ResultBody;
import com.mmc.payment.common.result.ResultEnum;
import com.mmc.payment.common.util.BeanCopyUtils;
import com.mmc.payment.common.util.CodeUtil;
import com.mmc.payment.config.RepoCashMethod;
import com.mmc.payment.dao.RepoCashDao;
import com.mmc.payment.entity.cash.CashTypeDO;
import com.mmc.payment.entity.repo.RepoCashDO;
import com.mmc.payment.entity.repo.RepoWalletDO;
import com.mmc.payment.model.dto.cash.CashTypeDTO;
import com.mmc.payment.model.dto.order.OrderInfoDTO;
import com.mmc.payment.model.dto.repo.PayCashResultDTO;
import com.mmc.payment.model.dto.repo.RepoCashDTO;
import com.mmc.payment.model.dto.repo.RepoWalletDTO;
import com.mmc.payment.model.dto.user.BaseAccountDTO;
import com.mmc.payment.model.dto.user.UserAccountSimpleDTO;
import com.mmc.payment.model.qo.RepoCashQO;
import com.mmc.payment.model.qo.UserCashQO;
import com.mmc.payment.model.qo.WalletMessageQO;
import com.mmc.payment.model.qo.WalletUsersQO;
import com.mmc.payment.model.vo.repo.RepoCashVO;
import com.mmc.payment.model.vo.repo.RepoOrderPayVO;
import com.mmc.payment.model.vo.wallet.WalletUsersVO;
import com.mmc.payment.service.RepoCashService;
import io.jsonwebtoken.lang.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small @Date 2023/5/24 10:06 @Version 1.0
 */
@Service
public class RepoCashServiceImpl implements RepoCashService {

    @Autowired
    private RepoCashDao repoCashDao;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;
  /* @Autowired
  private RepoWalletDao repoWalletDao;*/

  /*@Autowired
  private UserServletClient userServletClient;

  @Autowired
  private RepoServletClient repoServletClient;*/

    @Value("${userapp.url}")
    private String userAppUrl;

    @Value("${oms.url}")
    private String omsUrl;

    @Override
    public PageResult listPageRepoCash(BaseAccountDTO cuser, RepoCashQO param) {
        int count = repoCashDao.countPagePFRepoCash(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<RepoCashDO> list = repoCashDao.listPagePFRepoCash(param);
        List<Integer> userIds = new ArrayList<Integer>();
        for (RepoCashDO d : list) {
            if (d.getCreateUser() != null && !userIds.contains(d.getCreateUser())) {
                userIds.add(d.getCreateUser());
            }
        }

        ResponseEntity<String> responseEntity = UserId(cuser.getUserAccountId(), cuser.getToken());
        UserAccountSimpleDTO account = JSON.parseObject(responseEntity.getBody(), UserAccountSimpleDTO.class);
        list.stream().forEach(t -> {
            if (t.getCreateUser().equals(account.getId())) {
                t.setAccountName(account.getAccountNo());
                t.setUserName(account.getUserName());
            }
        });
        System.out.println(list);

        List<RepoCashDTO> data =
                list.stream()
                        .map(
                                d -> {
                                    return d.buildRepoCashDTO();
                                })
                        .collect(Collectors.toList());


        return PageResult.buildPage(pageNo, param.getPageSize(), count, data);
    }


    @Override
    public void updateCashRemark(Integer id, String remark) {

        repoCashDao.updateCashRemark(id, remark);
    }

    @Override
    public ResultBody reqCash(BaseAccountDTO cuser, RepoCashVO cash) {
        if (cuser.getPortType().equals(PortTypeEnum.CLIENTS_AND_APPLETS.getCode())) {
            return ResultBody.error(ResultEnum.FAILED_TO_CHARGE_MONEY);
        }
        // 金额范围验证
        /*if (!AmtUtil.vertifyRepoAmt(cash.getAmtPaid())) {
            return ResultBody.error(ResultEnum.AMT_PAID_VERITY_ERROR);
        }*/
        // 密码认证
        ResultBody body = passwordAuthentication(cuser, cash);
        if (body != null) {
            return body;
        }
        /**
         * 用户信息
         */
        ResponseEntity<String> responseEntity = UserId(cash.getRepoAccountId(), cuser.getToken());
        UserAccountSimpleDTO account = JSON.parseObject(responseEntity.getBody(), UserAccountSimpleDTO.class);
        if (account == null) {
            return ResultBody.error(ResultEnum.FEIGN_REPOUSER_SERVLET_ERROR);
        }

        RepoWalletDO wallet = repoCashDao.getRepoWalletInfo(cash.getRepoAccountId());
        if (wallet == null) {
            return ResultBody.error(ResultEnum.WALLET_NOT_FIND_ERROR);
        }
        // 扣除的金额不能大于余额
        BigDecimal amtPaid = cash.getAmtPaid();
        if (amtPaid.compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal negate = new BigDecimal(String.valueOf(amtPaid)).negate();
            if (negate.compareTo(wallet.getCashAmt()) > 0) {
                return ResultBody.error(ResultEnum.WALLET_CASH_NOT_ENOUGH_ERROR);
            }
        }

        Date cdate = new Date();
        RepoCashDO rc = new RepoCashDO();
        rc.setRepoAccountId(account.getId());
        rc.setUid(account.getUid());
        rc.setAccountName(account.getUserName());
        rc.setPayNo(CodeUtil.createRepoCashNo());
        rc.setPayMethod(RepoCashMethod.REG.getCode());
        rc.setAmtPaid(cash.getAmtPaid());
        BigDecimal newCashAmt =
                (wallet.getCashAmt().add(cash.getAmtPaid())).setScale(2, BigDecimal.ROUND_DOWN);
        rc.setCashAmt(newCashAmt);
        rc.setPayTime(cdate);
        String voucher =
                Collections.isEmpty(cash.getVoucher()) ? null : String.join(",", cash.getVoucher());
        rc.setVoucher(voucher);
        rc.setRemark(cash.getRemark());
        rc.setCreateTime(cdate);
        rc.setCreateUser(cuser.getUserAccountId());
        repoCashDao.insertRepoCash(rc);
        Integer id = account.getId();
        BigDecimal amtPaid1 = rc.getAmtPaid();
        repoCashDao.updateRepoWalletAmt(account.getId(), rc.getAmtPaid());
        return ResultBody.success();
    }

    @Override
    public ResultBody amountOfRefund(BaseAccountDTO cuser, String orderNo, BigDecimal actualPay, Integer repoAccountId, String refundNo) {
        if (cuser.getPortType().equals(PortTypeEnum.CLIENTS_AND_APPLETS.getCode())) {
            return ResultBody.error(ResultEnum.FAILED_TO_CHARGE_MONEY);
        }
        // 金额范围验证
        /*if (!AmtUtil.vertifyRepoAmt(cash.getAmtPaid())) {
            return ResultBody.error(ResultEnum.AMT_PAID_VERITY_ERROR);
        }*/
        // 密码认证
       /* ResultBody body = passwordAuthentication(cuser, cash);
        if (body != null) {
            return body;
        }*/
        /**
         * 用户信息
         */
        ResponseEntity<String> responseEntity = UserId(repoAccountId, cuser.getToken());
        UserAccountSimpleDTO account = JSON.parseObject(responseEntity.getBody(), UserAccountSimpleDTO.class);
        if (account == null) {
            return ResultBody.error(ResultEnum.FEIGN_REPOUSER_SERVLET_ERROR);
        }

        RepoWalletDO wallet = repoCashDao.getRepoWalletInfo(repoAccountId);
        if (wallet == null) {
            return ResultBody.error(ResultEnum.WALLET_NOT_FIND_ERROR);
        }
        // 扣除的金额不能大于余额
        BigDecimal amtPaid = actualPay;
        if (amtPaid.compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal negate = new BigDecimal(String.valueOf(amtPaid)).negate();
            if (negate.compareTo(wallet.getCashAmt()) > 0) {
                return ResultBody.error(ResultEnum.WALLET_CASH_NOT_ENOUGH_ERROR);
            }
        }

        Date cdate = new Date();
        RepoCashDO rc = new RepoCashDO();
        rc.setRepoAccountId(account.getId());
        rc.setUid(account.getUid());
        rc.setAccountName(account.getUserName());
        rc.setPayNo(CodeUtil.createRepoCashNo());
        rc.setPayMethod(RepoCashMethod.REG.getCode());
        rc.setAmtPaid(actualPay);
        BigDecimal newCashAmt =
                (wallet.getCashAmt().add(actualPay)).setScale(2, BigDecimal.ROUND_DOWN);
        rc.setCashAmt(newCashAmt);
        rc.setPayTime(cdate);
       /* String voucher =
                Collections.isEmpty(cash.getVoucher()) ? null : String.join(",", cash.getVoucher());*/
        rc.setCreateTime(cdate);
        rc.setCreateUser(cuser.getUserAccountId());
        rc.setRefundNo(refundNo);
        repoCashDao.insertRepoCash(rc);
        Integer id = account.getId();
        BigDecimal amtPaid1 = rc.getAmtPaid();
        repoCashDao.updateRepoWalletAmt(account.getId(), rc.getAmtPaid());
        return ResultBody.success();
    }

    /**
     * 密码认证
     *
     * @param cuser
     * @param cash
     * @return
     */
    private ResultBody passwordAuthentication(BaseAccountDTO cuser, RepoCashVO cash) {
        ResponseEntity<String> response =
                restTemplate.getForEntity(
                        userAppUrl
                                + "back-user/feignAuthUserPwd?authPwd="
                                + cash.getAuthPwd()
                                + "&id="
                                + +cuser.getUserAccountId(),
                        String.class);
        ResultBody body = JSON.parseObject(response.getBody(), ResultBody.class);
        if (!ResultEnum.SUCCESS.getResultCode().equals(body.getCode())) {
            return body;
        }
        return null;
    }

    private ResponseEntity<String> UserId(Integer repoAccountId, String token) {
        // 用户信息
     /*   ResponseEntity<String> response =
                restTemplate.getForEntity(
                        userAppUrl
                                + "user-account/feignGetUserSimpleInfo?userAccountId="
                                + repoAccountId,
                        String.class);*/
        HttpHeaders headers = new HttpHeaders();
        //封装请求头
        headers.add("token", token);
        HttpEntity<MultiValueMap<String, Object>> formEntity = new HttpEntity<MultiValueMap<String, Object>>(headers);
        ResponseEntity<String> response = restTemplate.exchange(userAppUrl + "user-account/feignGetUserSimpleInfo?userAccountId=" + repoAccountId,
                HttpMethod.GET, formEntity, String.class);
        return response;
    }

    @Override
    public ResultBody dedCash(BaseAccountDTO cuser, RepoCashVO cash) {
        // 金额范围验证
        /*if (!AmtUtil.vertifyRepoAmt(cash.getAmtPaid())) {
            return ResultBody.error(ResultEnum.AMT_PAID_VERITY_ERROR);
        }*/
        // 密码认证
        ResultBody body = passwordAuthentication(cuser, cash);
        if (body != null) {
            return body;
        }
        // 用户信息
        ResponseEntity<String> response = UserId(cash.getRepoAccountId(), cuser.getToken());
        String body1 = response.getBody();
        UserAccountSimpleDTO account = JSON.parseObject(body1, UserAccountSimpleDTO.class);
        if (account == null) {
            return ResultBody.error(ResultEnum.FEIGN_REPOUSER_SERVLET_ERROR);
        }

        RepoWalletDO wallet = repoCashDao.getRepoWalletInfo(cuser.getUserAccountId());
        if (wallet == null) {
            return ResultBody.error(ResultEnum.WALLET_NOT_FIND_ERROR);
        }
        // 扣除的金额不能大于余额
        BigDecimal amtPaid = cash.getAmtPaid();

        if (cash.getAmtPaid().compareTo(wallet.getCashAmt()) > 0) {
            return ResultBody.error(ResultEnum.WALLET_CASH_NOT_ENOUGH_ERROR);
        }
        Date cdate = new Date();
        RepoCashDO rc = new RepoCashDO();
        rc.setRepoAccountId(account.getId());
        rc.setUid(account.getUid());
        rc.setAccountName(account.getUserName());
        rc.setPayNo(CodeUtil.createRepoCashNo());
        rc.setPayMethod(RepoCashMethod.HANDLER.getCode());
        rc.setAmtPaid(cash.getAmtPaid().multiply(BigDecimal.valueOf(-1)));
        BigDecimal newCashAmt =
                (wallet.getCashAmt().subtract(cash.getAmtPaid())).setScale(2, BigDecimal.ROUND_DOWN);
        rc.setCashAmt(newCashAmt);
        rc.setPayTime(cdate);
        String voucher =
                Collections.isEmpty(cash.getVoucher()) ? null : String.join(",", cash.getVoucher());
        rc.setVoucher(voucher);
        rc.setRemark(cash.getRemark());
        rc.setCreateTime(cdate);
        rc.setCreateUser(cuser.getUserAccountId());
        repoCashDao.insertRepoCash(rc);
        repoCashDao.updateRepoWalletAmt(account.getId(), rc.getAmtPaid());
        return ResultBody.success();
    }

    @Override
    public RepoCashDTO getRefundInfo(String refundNo) {
        RepoCashDO refund = repoCashDao.getRefundCashInfo(refundNo);
        return refund == null ? null : refund.buildRepoCashDTO();
    }

    @Override
    public BigDecimal RemainingBalance(Integer repoAccountId) {
        return repoCashDao.RemainingBalance(repoAccountId);
    }

    @Override
    public ResultBody orderPayment(BaseAccountDTO currentAccount, String orderNo) {
        String s = stringRedisTemplate.opsForValue().get(orderNo);
        if (s == null) {
            return ResultBody.error(ResultEnum.THE_ORDER_HAS_BEEN_PAID);
        }
        RepoCashDO repoCashDO = JSONObject.parseObject(s, RepoCashDO.class);
        BigDecimal actualPay = repoCashDO.getActualPay();
        BigDecimal negate = new BigDecimal(String.valueOf(actualPay)).negate();

        RepoWalletDO wallet = repoCashDao.getRepoWalletInfo(currentAccount.getUserAccountId());
        if (wallet == null) {
            return ResultBody.error(ResultEnum.WALLET_NOT_FIND_ERROR);
        }
        if (!currentAccount.getUserAccountId().equals(currentAccount.getUserAccountId())) {
            return ResultBody.error(ResultEnum.WALLET_NOT_FIND_ERROR);
        }
        if (wallet.getCashAmt().compareTo(actualPay) == -1) {
            return ResultBody.error(ResultEnum.THE_CURRENT_AMOUNT_IS_INSUFFICIENT);
        }
        BigDecimal newCashAmt =
                (wallet.getCashAmt().add(negate)).setScale(2, BigDecimal.ROUND_DOWN);
        repoCashDO.setAmtPaid(negate);
        repoCashDO.setCashAmt(newCashAmt);
        repoCashDao.orderPayment(repoCashDO);
        repoCashDao.updateRepoWalletAmt(currentAccount.getUserAccountId(), negate);

        orderStatusChanges(currentAccount.getToken(), orderNo);
        return ResultBody.success();
    }

    @Override
    public PayCashResultDTO payCashOrder(RepoOrderPayVO orderPay) {
        BaseAccountDTO account = orderPay.getAccount();
        OrderInfoDTO orderInfo = orderPay.getOrderInfo();
        RepoWalletDO wallet = repoCashDao.getRepoWalletInfo(account.getUserAccountId());
        if (wallet == null) {
            return PayCashResultDTO.error(
                    ResultEnum.WALLET_NOT_FIND_ERROR.getResultCode(),
                    ResultEnum.WALLET_NOT_FIND_ERROR.getResultMsg());
        }
        BigDecimal amtPaid = orderInfo.getShouldPay();
        if (amtPaid.compareTo(wallet.getCashAmt()) > 0) {

            return PayCashResultDTO.error(
                    ResultEnum.WALLET_CASH_NOT_ENOUGH_ERROR.getResultCode(),
                    ResultEnum.WALLET_CASH_NOT_ENOUGH_ERROR.getResultMsg());
        }
        Date cdate = new Date();
        RepoCashDO cash = orderInfo.buildRepoCashDO();
        cash.setRepoAccountId(account.getUserAccountId());
        cash.setPayNo(CodeUtil.createRepoCashNo());
        cash.setPayMethod(RepoCashMethod.RENT.getCode());
        cash.setAmtPaid(amtPaid.multiply(BigDecimal.valueOf(-1)));
        cash.setCashAmt(wallet.getCashAmt().subtract(amtPaid));
        cash.setPayTime(cdate);
        cash.setCreateTime(cdate);
        repoCashDao.insertRepoCash(cash);
        repoCashDao.updateWalletAmt(account.getUserAccountId(), cash.getAmtPaid(), amtPaid);
        return PayCashResultDTO.success(amtPaid, cash.getPayNo());
    }

    @Override
    public PageResult listPagePayManager(BaseAccountDTO currentAccount, UserCashQO param) {
        int count = repoCashDao.countPagePayManager(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<RepoWalletDO> repoWalletDOS = repoCashDao.listPagePayManager(param);
        List<Integer> accountIds = repoWalletDOS.stream().map(RepoWalletDO::getRepoAccountId).collect(Collectors.toList());
        int size = 0;
        List<RepoWalletDTO> collect1 = null;
        if (accountIds.size() != 0) {
            WalletMessageQO walletMessageQO = new WalletMessageQO();
            walletMessageQO.setUserIds(accountIds);
            //参数设置
            List<RepoWalletDO> repoWalletDOS1 = getRepoWalletDOS(repoWalletDOS, walletMessageQO);
            size = repoWalletDOS1.size();
            collect1 = getRepoWalletDTOS(param, pageNo, repoWalletDOS1);

        }
        return PageResult.buildPage(pageNo, param.getPageSize(), size, collect1);
    }

    private List<RepoWalletDO> getRepoWalletDOS(List<RepoWalletDO> repoWalletDOS, WalletMessageQO walletMessageQO) {
        List<RepoWalletDO> repoWalletDOS1 = getRepoWalletDOS(walletMessageQO);
        repoWalletDOS1.stream().forEach(t -> {
            for (RepoWalletDO repoWalletDO : repoWalletDOS) {
                if (t.getId().equals(repoWalletDO.getRepoAccountId())) {
                    t.setCashAmt(repoWalletDO.getCashAmt());
                    t.setCashFreeze(repoWalletDO.getCashFreeze());
                    t.setCashPaid(repoWalletDO.getCashPaid());
                    t.setId(repoWalletDO.getId());
                    t.setRepoAccountId(repoWalletDO.getRepoAccountId());
                }
            }
        });
        return repoWalletDOS1;
    }

    private List<RepoWalletDTO> getRepoWalletDTOS(UserCashQO param, Integer pageNo, List<RepoWalletDO> repoWalletDOS1) {
        List<RepoWalletDTO> collect1;
        List<RepoWalletDO> subList = repoWalletDOS1.stream().skip((pageNo - 1) * param.getPageSize()).limit(param.getPageSize()).
                collect(Collectors.toList());
        if (param.getUserMassage() != "" && param.getUserMassage() != null) {
            List<RepoWalletDO> collect = subList.stream().filter(t ->
                    t.getUid().contains(param.getUserMassage()) || t.getUserName().contains(param.getUserMassage())
                            || t.getPhoneNum().contains(param.getUserMassage())
            ).collect(Collectors.toList());
            collect1 = collect.stream().map(d -> {
                return d.buildRepoWalletDTO();
            }).collect(Collectors.toList());
        } else {
            collect1 = subList.stream().map(d -> {
                return d.buildRepoWalletDTO();
            }).collect(Collectors.toList());
        }
        return collect1;
    }

    /**
     * ids 获取对应的用户信息
     *
     * @param walletMessageQO
     * @return
     */
    private List<RepoWalletDO> getRepoWalletDOS(WalletMessageQO walletMessageQO) {
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(userAppUrl + "back-user/feignListBAccountPage"
                , walletMessageQO, String.class);
        String body = responseEntity.getBody();
        List<RepoWalletDO> repoWalletDOS1 = JSONArray.parseArray(body, RepoWalletDO.class);
        return repoWalletDOS1;
    }

    /**
     * 立即付款 修改订单编号
     *
     * @param orderNo
     * @return
     */
    private void orderStatusChanges(String token, String orderNo) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity<MultiValueMap<String, Object>> formEntity = new HttpEntity<MultiValueMap<String, Object>>(headers);
        ResponseEntity<String> exchange = restTemplate.exchange(omsUrl + "RentalOrders/orderStatusChanges?orderNo=" + orderNo + "&tranStatus=" + 200,
                HttpMethod.GET, formEntity, String.class);
        System.out.println(exchange);

    }


    @Override
    public ResultBody walletUsers(WalletUsersVO walletUsersVO) {
        //  ResponseEntity<String> response = UserId(walletUsersVO.getRepoAccountId(),walletUsersVO.get);
        // String body1 = response.getBody();
        //UserAccountSimpleDTO account = JSON.parseObject(body1, UserAccountSimpleDTO.class);
       /* if (account == null) {
            return ResultBody.error(ResultEnum.FEIGN_REPOUSER_SERVLET_ERROR);
        } else if (account.getPortType().equals(PortTypeEnum.ADMIN_ACCOUNTS.getCode())) {
            return ResultBody.error(ResultEnum.NO_WALLET_FUNCTION);
        }*/
        WalletUsersQO properties = BeanCopyUtils.properties(walletUsersVO, new WalletUsersQO());
        Integer walletUsers = repoCashDao.findWalletUsers(properties);
        if (walletUsers != null) {
            return ResultBody.error("当前用户已有钱包");
        }
        repoCashDao.walletUsers(properties);
        return ResultBody.success();
    }

    @Override
    public ResultBody cashType() {
        List<CashTypeDO> cashTypeDOS = repoCashDao.cashType();
        List<CashTypeDTO> collect = cashTypeDOS.stream().map(d -> {
            return d.buildCashTypeDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody userWallet(BaseAccountDTO currentAccount) {
        RepoWalletDO repoWalletDO = repoCashDao.userWallet(currentAccount.getUserAccountId());
        if (null == repoWalletDO) {
            return ResultBody.error("当前账号没有钱包");
        }
        RepoWalletDTO repoWalletDTO = repoWalletDO.buildRepoWalletDTO();
        return ResultBody.success(repoWalletDTO);
    }


    public List<RepoWalletDTO> listWalletInfo(UserCashQO param) {
        if (CollectionUtils.isEmpty(param.getAccountIds())) {
            return java.util.Collections.emptyList();
        }
        List<RepoWalletDO> wallets = repoCashDao.listWalletInfo(param);
        return wallets.stream().map(d -> {
            return d.buildRepoWalletDTO();
        }).collect(Collectors.toList());
    }


}
