package com.mmc.payment.controller;

import com.mmc.payment.common.result.ResultBody;
import com.mmc.payment.model.vo.order.OrderRequestParamsVO;
import com.mmc.payment.service.WechatPayService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;

/**
 * @Author LW
 * @date 2023/7/19 14:26
 * 概要：
 */
@Api(tags = {"微信支付-相关接口"})
@RestController
@RequestMapping("/wechat/")
public class WechatPayController extends BaseController {
    @Resource
    WechatPayService wechatPayService;

    @ApiOperation(value = "小程序调起支付API")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("pay")
    public ResultBody orderPay(@RequestBody OrderRequestParamsVO orderRequestParamsVO, HttpServletRequest request) throws IOException {
        return wechatPayService.orderPay(orderRequestParamsVO, this.getUserLoginInfoFromRedis(request).getUserAccountId(), request);
    }

    @ApiOperation(value = "支付异步通知")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("payCallback")
    public Map payCallback(HttpServletRequest request) {
        return wechatPayService.payCallback(request);
    }
}
