package com.mmc.oms.util;

import org.springframework.beans.BeanUtils;

import java.util.Objects;

/**
 * @author 作者 dahang
 * @version 创建时间：2022年7月23日
 * @explain 同名属性拷贝值
 */
public class BeanCopyUtils {

    public static <T> T properties(Object source, T target) {
        if (Objects.isNull(source)) {
            return target;
        }
        BeanUtils.copyProperties(source, target);
        return target;
    }

    public static <T> T properties(Object source, Class<T> target) {
        T t = null;
        try {
            t = target.newInstance();
            if (Objects.isNull(source)) {
                return t;
            }
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        BeanUtils.copyProperties(source, t);
        return t;
    }
}
