package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.MallOrderExpressDTO;
import com.mmc.oms.model.dto.mall.UserAddressDTO;
import com.mmc.oms.model.vo.mall.MallOrderExpressVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/6/2 20:29
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MallOrderExpressDO implements Serializable {
	private static final long serialVersionUID = 1L;

	private Integer id;
	private Integer orderId;
	private String sendExpNo;
	private String sendExpCode;
	private String takeName;
	private String takePhone;
	private String takeRegion;
	private String takeAddress;
	private Date receiveTime;
	private Integer receive;
	private Date updateTime;
	private Date createTime;

	public MallOrderExpressDO(MallOrderExpressVO param) {
		this.orderId=param.getOrderId();
		this.sendExpCode=param.getSendExpCode();
		this.sendExpNo=param.getSendExpNo();
		this.takeName = param.getTakeName();
		this.takePhone = param.getTakePhone();
		this.takeRegion = param.getTakeRegion();
		this.takeAddress = param.getTakeAddress();
		this.receiveTime = param.getReceiveTime();
		this.receive = param.getReceive();
	}

	public MallOrderExpressDO(UserAddressDTO param) {
		this.takeName = param.getTakeName();
		this.takePhone = param.getTakePhone();
		this.takeRegion = param.getTakeRegion();
		this.takeAddress = param.getTakeAddress();
	}

	public MallOrderExpressDTO buildOrderExpressDTO() {
		return MallOrderExpressDTO.builder().orderId(orderId).sendExpNo(sendExpNo).sendExpCode(sendExpCode)
				.takeName(takeName).takePhone(takePhone).takeRegion(takeRegion).takeAddress(takeAddress).build();
	}
}
