package com.mmc.oms.model.dto.lease;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.oms.model.dto.kdn.KdnExpDTO;
import com.mmc.oms.model.dto.uav.UavOrderExpressDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: lw
 * @Date: 2023/9/4 14:50
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "最新版-订单")
public class LeaseOrderDTO implements Serializable {
    private static final long serialVersionUID = 7548192478556457453L;
    @ApiModelProperty("id")
    private Integer id;
    @ApiModelProperty("订单编号")
    private String orderNo;
    @ApiModelProperty("订单名称")
    private String orderName;
    @ApiModelProperty("订单状态")
    private Integer statusCode;
    @ApiModelProperty("买家id")
    private Integer userAccountId;
    @ApiModelProperty("买家手机号")
    private String phoneNum;
    @ApiModelProperty("买家姓名")
    private String userName;
    @ApiModelProperty("买家昵称")
    private String nickname;
    @ApiModelProperty("卖家id")
    private Integer thirdBackUserAccountId;
    @ApiModelProperty("卖家企业名称")
    private String companyName;
    @ApiModelProperty("订单实付总额")
    private BigDecimal orderTotalAmount;
    @ApiModelProperty("订单需付金额")
    private BigDecimal needPayAmount;
    @ApiModelProperty("抵扣佣金余额")
    private BigDecimal salaryAmount;
    @ApiModelProperty("抵扣云享金余额")
    private BigDecimal shareAmount;
    @ApiModelProperty("云享金押金抵扣")
    private BigDecimal shareCashPledge;
    @ApiModelProperty("余额押金抵扣")
    private BigDecimal salaryCashPledge;
    @ApiModelProperty("其他方式支付额度")
    private BigDecimal otherAmount;
    @ApiModelProperty("wechatpay微信，alipay支付宝，offline线下")
    private String payType;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("租赁开始时间")
    private Date startDate;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("租赁结束时间")
    private Date endDate;
    @ApiModelProperty("买家备注")
    private String userRemark;
    @ApiModelProperty("卖家备注")
    private String sellerRemark;
    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    @ApiModelProperty("支付时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date payTime;
    @ApiModelProperty("确认收货时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmReceiptTime;
    @ApiModelProperty(value = "修改版本", hidden = true)
    private Integer version;
    @ApiModelProperty("评价状态")
    private Integer remarkStatus;
    @ApiModelProperty("最近修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    @ApiModelProperty("用户收货地址信息")
    private UavOrderExpressDTO uavOrderExpressDTO;
    @ApiModelProperty("发货快递信息")
    private KdnExpDTO kdnExpDTO;
    @ApiModelProperty("归还快递信息")
    private KdnExpDTO returnKdnExpDTO;
    @ApiModelProperty("确认收货的信息")
    private LeaseRefundOrderDTO confirmReceipt;
    @ApiModelProperty("购买数量")
    private Integer wareNum;
    @ApiModelProperty(value = "单价", hidden = true)
    private BigDecimal unitPrice;
    @ApiModelProperty(value = "押金", hidden = true)
    private BigDecimal deposit;
    @ApiModelProperty("租赁商品id")
    private Integer leaseGoodsId;
    @ApiModelProperty("订单规格列表")
    private String sku;
    @ApiModelProperty("sku图片")
    private String skuImg;
    @ApiModelProperty("运费")
    private String modeOfDeliveryInfo;
    @ApiModelProperty("发货后申请退款")
    private LeaseRefundOrderDTO leaseRefundOrder;
    @ApiModelProperty("商户确认收货信息")
    private LeaseRefundOrderDTO storeReceiveOrder;
}
