package com.mmc.oms.entity.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 用户地址表
 * </p>
 *
 * @author dahang
 * @since 2022-08-31
 */
@Data
@ApiModel(value="UserAddressDO", description="用户地址表")
@AllArgsConstructor
@NoArgsConstructor
public class UserAddressDO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "唯一标识")
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;

    @ApiModelProperty(value = "收货人姓名")
    private String takeName;

    @ApiModelProperty(value = "收货人电话")
    private String takePhone;

    @ApiModelProperty(value = "收货地址")
    private String takeRegion;

    @ApiModelProperty(value = "收货详细地址")
    private String takeAddress;

    @ApiModelProperty(value = "使用类型;0默认，1普通")
    private Integer type;

    @ApiModelProperty(value = "创建时间")
    private Date createdTime;

    @ApiModelProperty(value = "更新时间")
    private Date updatedTime;

    @ApiModelProperty(value = "逻辑删除;1代表删除，0代表未删除")
    private Integer isDeleted;

    @ApiModelProperty(value = "逻辑删除")
    private List<Integer> isDeleteds;

    @ApiModelProperty(value = "标识;0是后台管理 100客户端 小程序")
    private Integer flag;

    @ApiModelProperty(value = "市code编码")
    private String districtCode;

    public UserAddressDO(Integer userAccountId, Integer type,Integer flag) {
        this.userAccountId = userAccountId;
        this.type = type;
        this.flag = flag;
    }
}
