package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.MallGoodsInfoDTO;
import com.mmc.oms.model.dto.mall.MallOrderProdListDTO;
import com.mmc.oms.model.dto.mall.OrderGoodsIndstProdListDTO;
import com.mmc.oms.model.excel.OrderItem;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * author:zhenjie
 * Date:2022/10/21
 * time:16:33
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderGoodsIndstProdListDO implements Serializable {
    private static final long serialVersionUID = 8484209497772442916L;
    private Integer id;
    private Integer goodsInfoId;
    private Integer orderGoodsIndstDetailId;
    private String goodsTypeName;
    private String productName;
    private String model;
    private String productBrand;
    private Integer productSpecId;
    private String prodSkuSpecName;
    private String prodSkuSpecImage;
    private String partNo;
    private String versionDesc;
    private Integer buyNum;
    private Date createTime;
    private Date updateTime;
    private String unitName;
    private BigDecimal unitPrice;

    public OrderGoodsIndstProdListDTO buildOrderGoodsIndstProdListDTO(){
        return OrderGoodsIndstProdListDTO.builder().id(this.id).orderGoodsIndstDetailId(this.orderGoodsIndstDetailId).goodsTypeName(this.goodsTypeName).productName(this.productName)
                .model(this.model).productBrand(this.productBrand).productSpecId(this.productSpecId).prodSkuSpecName(this.prodSkuSpecName).prodSkuSpecImage(this.prodSkuSpecImage).partNo(this.partNo)
                .versionDesc(this.versionDesc).buyNum(this.buyNum).createTime(this.createTime).updateTime(this.updateTime).unitName(this.unitName).build();
    }

    public MallOrderProdListDTO buildMallOrderProdListDTO(){
        return MallOrderProdListDTO.builder().id(this.id).goodsInfoId(this.goodsInfoId).prodSkuSpecName(this.prodSkuSpecName).prodSkuSpecImage(this.prodSkuSpecImage).partNo(this.partNo)
                .versionDesc(this.versionDesc).buyNum(this.buyNum).model(this.model).build();
    }

    public OrderItem buildMallOrderItemLis(){
        return OrderItem.builder().productName(this.prodSkuSpecName).liaoNo(this.partNo).versionDesc(this.versionDesc).quantity(this.buyNum).model(this.model).build();
    }

    public MallGoodsInfoDTO buildMallGoodsInfoDTO(){
        return MallGoodsInfoDTO.builder().productName(this.prodSkuSpecName).count(this.buyNum).unitPrice(this.unitPrice).build();
    }

    public OrderGoodsIndstProdListDO(OrderGoodsIndstProdListDTO orderGoodsIndstProdListDTO){
        this.id = orderGoodsIndstProdListDTO.getId();
        this.orderGoodsIndstDetailId = orderGoodsIndstProdListDTO.getOrderGoodsIndstDetailId();
        this.goodsTypeName = orderGoodsIndstProdListDTO.getGoodsTypeName();
        this.productName = orderGoodsIndstProdListDTO.getProductName();
        this.model = orderGoodsIndstProdListDTO.getModel();
        this.productBrand = orderGoodsIndstProdListDTO.getProductBrand();
        this.productSpecId = orderGoodsIndstProdListDTO.getProductSpecId();
        this.prodSkuSpecName = orderGoodsIndstProdListDTO.getProdSkuSpecName();
        this.prodSkuSpecImage = orderGoodsIndstProdListDTO.getProdSkuSpecImage();
        this.partNo = orderGoodsIndstProdListDTO.getPartNo();
        this.versionDesc = orderGoodsIndstProdListDTO.getVersionDesc();
        this.buyNum = orderGoodsIndstProdListDTO.getBuyNum();
        this.unitName = orderGoodsIndstProdListDTO.getUnitName();
    }

}
