package com.mmc.oms.model.vo.mall;

import com.mmc.oms.common.publicinterface.Auto;
import com.mmc.oms.common.publicinterface.Confirm;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/3 15:48
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderPayVO implements Serializable {
    private static final long serialVersionUID = -7118568598001208480L;
    @ApiModelProperty(value = "orderId")
    @NotNull(message = "订单ID不能为空", groups = { Auto.class, Confirm.class })
    private Integer orderId;
    @ApiModelProperty(value = "支付凭证-图片")
    @NotNull(message = "支付凭证-图片不能为空", groups = { Confirm.class })
    private List<String> vouchr;
    @ApiModelProperty(value = "支付类型-0全款 1分期付款(预付款) 2尾款 3验收单")
    @NotNull(message = "支付类型不能为空", groups = { Confirm.class })
    private Integer payType;
    @ApiModelProperty(value = "备注")
    private String payRemark;
}
