package com.mmc.oms.model.dto.company;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/31 16:49
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
//@ApiModel(value="CompanyInfoPO对象", description="单位详情")
public class CompanyInfoDTO implements Serializable {

    private static final long serialVersionUID = -7580347447230474435L;
    private Integer id;
    private Integer parentId;
    private String company;
    private String fullName;
    private String contactPhone;
    private String contacts;
    private String area;
    private String address;
    private String remark;
    private Integer manage;
    private Integer deleted;
    private Integer leftNo;
    private Integer rightNo;
    private Date updateTime;
    private Date createTime;

    /**
     * 辅助字段-start
     *
     * @param param
     */
    private Integer userType;

    @ApiModelProperty(value = "渠道等级")
    private String channelLevel;

    @ApiModelProperty(value = "收款银行")
    private String dueBank;

    @ApiModelProperty(value = "银行卡号")
    private String bankCard;
}
