package com.mmc.oms.feign.hystrix;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.feign.PmsAppApi;
import com.mmc.oms.model.dto.mall.*;
import com.mmc.oms.model.qo.mall.MallOrderGoodsInfoQO;
import com.mmc.oms.model.qo.mall.ProductSpecPriceQO;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/5 15:19
 */
@Slf4j
public class PmsAppApiHystrix implements PmsAppApi {
    @Override
    public List<MallGoodsShopCarDTO> fillGoodsInfo(List<MallGoodsShopCarDTO> param, String token) {
        log.info("熔断：MallGoodsClientHystrix.fillGoodsInfo==error==>param:{}", JSONObject.toJSONString(param));
        return null;
    }

    @Override
    public List<OrderGoodsProdDTO> feignListProdGoodsSkuInfo(MallOrderGoodsInfoQO mallOrderGoodsInfoQO, String token) {
        log.info("熔断：MallGoodsClientHystrix.feignListProdGoodsSkuInfo==error==>param:{}", JSONObject.toJSONString(mallOrderGoodsInfoQO));
        return null;
    }

    @Override
    public List<OrderGoodsIndstDTO> feignListIndstGoodsSkuInfo(MallOrderGoodsInfoQO mallOrderGoodsInfoQO, String token) {
        log.info("熔断：MallGoodsClientHystrix.feignListIndstGoodsSkuInfo==error==>param:{}", JSONObject.toJSONString(mallOrderGoodsInfoQO));
        return null;
    }

    @Override
    public List<MallProductSpecPriceDTO> feignListProductSpecPrice(ProductSpecPriceQO productSpecPriceQO, String token) {
        log.info("熔断：MallGoodsClientHystrix.feignListProductSpecPrice==error==>param:{}", JSONObject.toJSONString(productSpecPriceQO));
        return null;
    }

    @Override
    public ProductSpecPriceDTO feignGetUnitPriceByTag(Integer specId, Integer tagId, String token) {
        log.info("熔断：MallGoodsClientHystrix.feignGetUnitPriceByTag==error==>param:{}",specId,tagId);
        return null;
    }
}
