package com.mmc.oms.model.dto.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * author:zhenjie
 * Date:2022/11/9
 * time:17:17
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.mall.dto.MallProductSpecPriceDTO", description = "产品对应价格")
public class MallProductSpecPriceDTO implements Serializable {
    private static final long serialVersionUID = 4717398210156973205L;
    @ApiModelProperty(value = "产品规格id")
    private Integer productSpecId;
    @ApiModelProperty(value = "合作价格")
    private BigDecimal opPrice;
    @ApiModelProperty(value = "市场价格")
    private BigDecimal mkPrice;
}
