package com.mmc.oms.model.vo.lease;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: lw
 * @Date: 2023/9/21 16:01
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AddLeaseOrderVO implements Serializable {
    private static final long serialVersionUID = 2749055915508197141L;
    @ApiModelProperty("商家id")
    private Integer thirdBackUserAccountId;
    @ApiModelProperty("卖家企业名称")
    private String companyName;
    @ApiModelProperty("租赁商品id")
    private Integer leaseGoodsId;
    @ApiModelProperty("收货地址id")
    private Integer userAddressId;
    @ApiModelProperty(value = "订单实付总额", hidden = true)
    private BigDecimal orderTotalAmount;
    @ApiModelProperty(value = "抵扣钱包余额", hidden = true)
    private BigDecimal walletAmount;
    @ApiModelProperty(value = "抵扣云享金余额", hidden = true)
    private BigDecimal shareAmount;
    @ApiModelProperty(value = "云享金抵扣押金金额", hidden = true)
    private BigDecimal shareCashPledgeAmount;
    @ApiModelProperty(value = "余额抵扣押金金额", hidden = true)
    private BigDecimal salaryCashPledgeAmount;
    @ApiModelProperty(value = "其他方式支付额度", hidden = true)
    private BigDecimal otherAmount;
    @ApiModelProperty(value = "租期", hidden = true)
    private Integer leaseTerm;
    @ApiModelProperty("用户备注")
    private String userRemark;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("租赁开始时间")
    private Date startDate;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("租赁结束时间")
    private Date endDate;
    @ApiModelProperty("购买数量")
    private Integer wareNum;
    @ApiModelProperty(value = "单价", hidden = true)
    private BigDecimal unitPrice;
    @ApiModelProperty(value = "押金", hidden = true)
    private BigDecimal deposit;
    @ApiModelProperty("sku")
    private String sku;
    @ApiModelProperty("是否抵扣云享金，0否，1是")
    private Integer deductShareAmount;
    @ApiModelProperty("是否抵扣余额，0否，1是")
    private Integer deductSalaryAmount;
}
