package com.mmc.oms.model.dto.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/26 11:06
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.SkuOrderDTO", description = "计算租金QO")
public class SkuOrderDTO implements Serializable {
    private static final long serialVersionUID = -8313939232076188505L;
    @ApiModelProperty(value = "商品ID")
    private Integer wareInfoId;
    @ApiModelProperty(value = "skuID")
    private Integer skuInfoId;
    @ApiModelProperty(value = "商品编号")
    private String wareNo;
    @ApiModelProperty(value = "商品标题")
    private String wareTitle;
    @ApiModelProperty(value = "商品主图片Url")
    private String mainImg;
    @ApiModelProperty(value = "sku标题")
    private String skuTitle;
    @ApiModelProperty(value = "减库方式- 0:买家拍下减库存 1:卖家付款减库存", hidden = true)
    private Integer payStatus;
    @ApiModelProperty(value = "单价")
    private BigDecimal unitPrice;
    @ApiModelProperty(value = "购买数量")
    private Integer wareNum;
    @ApiModelProperty(value = "库存数量")
    private Integer stockNum;
    @ApiModelProperty(value = "租赁天数")
    private Integer rentDay;
    @ApiModelProperty(value = "押金总额")
    private BigDecimal deposit;
    @ApiModelProperty(value = "租金总额")
    private BigDecimal rentPrice;
    @ApiModelProperty(value = "应付款总额")
    private BigDecimal shouldPay;
    @ApiModelProperty(value = "辅助字段---数据库版本号")
    private Integer pid;

}
