package com.mmc.oms.model.dto.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>
 * 服务订单状态
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceOrderStatusInfoDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private Integer orderStatus;

    @ApiModelProperty(value = "用户端状态描述")
    private String userPort;

    @ApiModelProperty(value = "飞手端状态描述")
    private String flyerPort;

    @ApiModelProperty(value = "后台端状态描述")
    private String managePort;
}
