package com.mmc.oms.feign;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.feign.hystrix.PmsAppApiHystrix;
import com.mmc.oms.model.dto.uav.UavCartDTO;
import com.mmc.oms.model.qo.uav.PriceStockQO;
import com.mmc.oms.model.vo.lease.LeaseGoodsVO;
import com.mmc.oms.model.vo.uav.MallGoodsVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/5 15:18
 */
@FeignClient(url = "${pms.url}", name = "pms-svc", fallback = PmsAppApiHystrix.class)
public interface PmsAppApi {
    @GetMapping("lease/goods/feignLeaseGoodsInfoByAddressId")
    public ResultBody feignLeaseGoodsInfoByAddressId(@RequestParam Integer id);

    @PostMapping("app/goods/listPriceStock")
    List<UavCartDTO> listPriceStock(@RequestBody List<PriceStockQO> priceStockQOS);

    @GetMapping("app/lease/leaseGoodsDetails")
    ResultBody<LeaseGoodsVO> leaseGoodsDetails(@RequestParam Integer id);

    @GetMapping("/app/goods/appMallGoodsDetails")
    ResultBody<MallGoodsVO> mallGoodsDetails(@RequestParam Integer id);
}
