package com.mmc.oms.entity.uav;

import com.mmc.oms.model.dto.uav.UavCartDTO;
import com.mmc.oms.model.dto.uav.UavOrderSkuDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/4 14:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("最新版-订单sku")
public class UavOrderSkuDO implements Serializable {
    private static final long serialVersionUID = 8711946446973624100L;
    @ApiModelProperty("订单规格id")
    private Integer id;
    @ApiModelProperty("订单id")
    private Integer uavOrderId;
    @ApiModelProperty("采购订单id")
    private Integer uavPurchaseOrderId;
    @ApiModelProperty("商品id")
    private Integer mallGoodsId;
    @ApiModelProperty("商品名称")
    private String tradeName;
    @ApiModelProperty("商品规格id")
    private Integer priceStockId;
    @ApiModelProperty("商品规格")
    private String productSpec;
    @ApiModelProperty("购买数量")
    private Integer orderNum;
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;
    @ApiModelProperty("商品规格图片")
    private String skuImage;
    @ApiModelProperty("商品规格编号")
    private String skuNo;
    @ApiModelProperty("下单时间")
    private Date createTime;

    public UavOrderSkuDTO buildUavOrderSkuDTO(){
        return UavOrderSkuDTO.builder().id(this.id).uavOrderId(this.uavOrderId).mallGoodsId(this.mallGoodsId).tradeName(this.tradeName)
                .priceStockId(this.priceStockId).productSpec(this.productSpec).orderNum(this.orderNum).unitPrice(this.unitPrice).skuImage(this.skuImage)
                .skuNo(this.skuNo).createTime(this.createTime).build();
    }

    public UavOrderSkuDO(UavCartDTO uavCartDTO){
        this.mallGoodsId = uavCartDTO.getMallGoodsId();
        this.orderNum = uavCartDTO.getOrderNum();
        this.unitPrice = uavCartDTO.getSalePrice();
        this.productSpec = uavCartDTO.getProductSpec();
        this.tradeName = uavCartDTO.getTradeName();
        this.skuNo = uavCartDTO.getSkuNo();
        this.skuImage = uavCartDTO.getSkuImage();
        this.priceStockId = uavCartDTO.getPriceStockId();
    }

}
