package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.MallGoodsInfoDTO;
import com.mmc.oms.model.dto.mall.MallOrderProdListDTO;
import com.mmc.oms.model.dto.mall.OrderGoodsProdDetailDTO;
import com.mmc.oms.model.excel.OrderItem;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/6/2 20:29
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderGoodsProdDetailDO implements Serializable {
    private static final long serialVersionUID = -4284152753668273560L;
    private Integer id;
    private Integer goodsInfoId;
    private Integer orderGoodsProdId;
    private Integer mallProdShopCarDetailId;
    private Integer mallProdSkuInfoSpecId;
    private Integer mallProdSkuInfoId;
    private String goodsTypeName;
    private String productName;
    private String model;
    private String productBrand;
    private Integer brandInfoId;
    private Integer productSpecId;
    private String specName;
    private String prodSkuSpecImage;
    private String partNo;
    private String versionDesc;
    private Integer buyNum;
    private BigDecimal unitPrice;
    private BigDecimal skuSpecAmount;
    private BigDecimal detailDiscountPrice;
    private BigDecimal afterDiscountPrice;
    private String unitName;
    private Date createTime;
    private Date updateTime;

    public OrderGoodsProdDetailDTO buildOrderGoodsProdDetailDTO(){
        return OrderGoodsProdDetailDTO.builder().id(this.id).orderGoodsProdId(this.orderGoodsProdId).mallProdShopCarDetailId(this.mallProdShopCarDetailId).mallProdSkuInfoSpecId(this.mallProdSkuInfoSpecId).mallProdSkuInfoId(this.mallProdSkuInfoId)
                .specName(this.specName).prodSkuSpecImage(this.prodSkuSpecImage).partNo(this.partNo).versionDesc(this.versionDesc).buyNum(this.buyNum).unitPrice(this.unitPrice)
                .skuSpecAmount(this.unitPrice.multiply(BigDecimal.valueOf(this.buyNum))).goodsTypeName(this.goodsTypeName).productName(this.productName).model(this.model).productBrand(this.productBrand).brandInfoId(this.brandInfoId)
                .productSpecId(this.productSpecId).createTime(this.createTime).updateTime(this.updateTime).unitName(this.unitName).build();
    }

    public MallOrderProdListDTO buildMallOrderProdListDTO(){
        return MallOrderProdListDTO.builder().id(this.id).goodsInfoId(this.goodsInfoId).prodSkuSpecName(this.specName).prodSkuSpecImage(this.prodSkuSpecImage).partNo(this.partNo)
                .versionDesc(this.versionDesc).buyNum(this.buyNum).unitPrice(this.unitPrice).skuSpecAmount(this.skuSpecAmount).productName(this.productName).model(this.model).build();
    }

    public OrderItem buildMallOrderItemLis(){
        return OrderItem.builder().productName(this.specName).liaoNo(this.partNo).quantity(this.buyNum).versionDesc(this.versionDesc).model(this.model).build();
    }

    public MallGoodsInfoDTO buildMallGoodsInfoDTO(){
        return MallGoodsInfoDTO.builder().productName(this.specName).count(this.buyNum).unitPrice(this.unitPrice).build();
    }

//    public OGSkuSpecDTO buildOGSkuSpecDTO(){
//        return OGSkuSpecDTO.builder().id(this.id).skuSpecName(this.specName).build();
//    }

    public OrderGoodsProdDetailDO(OrderGoodsProdDetailDTO orderGoodsProdDetailDTO){
        this.id = orderGoodsProdDetailDTO.getId();
        this.orderGoodsProdId = orderGoodsProdDetailDTO.getOrderGoodsProdId();
        this.mallProdSkuInfoSpecId = orderGoodsProdDetailDTO.getMallProdSkuInfoSpecId();
        this.mallProdSkuInfoId = orderGoodsProdDetailDTO.getMallProdSkuInfoId();
        this.goodsTypeName = orderGoodsProdDetailDTO.getGoodsTypeName();
        this.productName = orderGoodsProdDetailDTO.getProductName();
        this.model = orderGoodsProdDetailDTO.getModel();
        this.productBrand = orderGoodsProdDetailDTO.getProductBrand();
        this.brandInfoId = orderGoodsProdDetailDTO.getBrandInfoId();
        this.productSpecId = orderGoodsProdDetailDTO.getProductSpecId();
        this.specName = orderGoodsProdDetailDTO.getSpecName();
        this.prodSkuSpecImage = orderGoodsProdDetailDTO.getProdSkuSpecImage();
        this.partNo = orderGoodsProdDetailDTO.getPartNo();
        this.versionDesc = orderGoodsProdDetailDTO.getVersionDesc();
        this.buyNum = orderGoodsProdDetailDTO.getBuyNum();
        this.unitPrice = orderGoodsProdDetailDTO.getUnitPrice();
        this.skuSpecAmount = orderGoodsProdDetailDTO.getSkuSpecAmount();
        this.unitName = orderGoodsProdDetailDTO.getUnitName();
    }

}
