package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.OrderGoodsIndstDetailDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * author:zhenjie
 * Date:2022/10/21
 * time:16:32
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderGoodsIndstDetailDO implements Serializable {
    private static final long serialVersionUID = 138856551730423056L;
    private Integer id;
    private Integer orderGoodsIndstId;
    private Integer mallIndstShopCarDetailId;
    private Integer mallIndstSkuInfoSpecId;
    private Integer industrySpecId;
    private String industrySkuSpecName;
    private String industrySkuSpecImage;
    private Integer buyNum;
    private BigDecimal unitPrice;
    private BigDecimal skuSpecAmount;
    private Date createTime;
    private Date updateTime;
    private String unitName;

    private List<OrderGoodsIndstProdListDO> orderGoodsIndstProdListDOS;

    public OrderGoodsIndstDetailDO(OrderGoodsIndstDetailDTO orderGoodsIndstDetailDTO){
        this.id = orderGoodsIndstDetailDTO.getId();
        this.orderGoodsIndstId = orderGoodsIndstDetailDTO.getOrderGoodsIndstId();
        this.mallIndstShopCarDetailId = orderGoodsIndstDetailDTO.getMallIndstShopCarDetailId();
        this.mallIndstSkuInfoSpecId = orderGoodsIndstDetailDTO.getMallIndstSkuInfoSpecId();
        this.industrySpecId = orderGoodsIndstDetailDTO.getIndustrySpecId();
        this.industrySkuSpecName = orderGoodsIndstDetailDTO.getIndustrySkuSpecName();
        this.industrySkuSpecImage = orderGoodsIndstDetailDTO.getIndustrySkuSpecImage();
        this.buyNum = orderGoodsIndstDetailDTO.getBuyNum();
        this.unitPrice = orderGoodsIndstDetailDTO.getUnitPrice();
        this.skuSpecAmount = orderGoodsIndstDetailDTO.getSkuSpecAmount();
        this.unitName = orderGoodsIndstDetailDTO.getUnitName();
    }

}
