package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.MallGoodsShopCarDTO;
import com.mmc.oms.model.vo.mall.MallShopCarVO;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/6/3 20:14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("购物车-行业商品")
public class MallIndstShopCarDO implements Serializable {
    private static final long serialVersionUID = -6119563034611575618L;
    private Integer id;
    private Integer userAccountId;
    private Integer goodsInfoId;
    private Integer buyNum;
    private Integer saleStatus;
    private Integer recMallUserId;
    private String remark;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    private List<MallIndstShopCarDetailDO> shopCarDetailDOS;

    public MallIndstShopCarDO(MallShopCarVO param) {
        this.userAccountId = param.getUserAccountId();
        this.goodsInfoId = param.getGoodsInfoId();
        this.buyNum = param.getBuyNum();
        this.recMallUserId = param.getRecMallUserId();
        this.remark = param.getRemark();
    }

    public MallGoodsShopCarDTO buildMallGoodsShopCarDTO(){
        return MallGoodsShopCarDTO.builder().id(this.id).userAccountId(this.userAccountId).goodsInfoId(this.goodsInfoId).buyNum(this.buyNum).directoryId(2)
                .saleStatus(this.saleStatus).recMallUserId(this.recMallUserId).remark(this.remark).deleted(this.deleted).createTime(this.createTime)
                .skuList(this.shopCarDetailDOS.stream().map(d->{ return d.buildMallSkuInfoSpecDTO();}).collect(Collectors.toList()))
                .build();
    }
}
