package com.mmc.oms.controller.uav;

import com.mmc.oms.common.publicinterface.Page;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.uav.UavPurchaseOrderDTO;
import com.mmc.oms.model.qo.uav.UavPOrderQO;
import com.mmc.oms.model.vo.uav.UavOrderExpressVO;
import com.mmc.oms.model.vo.uav.UavOrderPayVO;
import com.mmc.oms.model.vo.uav.UavPOConfirmVO;
import com.mmc.oms.service.uav.UavPOService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/9/9 10:01
 */
@Api(tags = { "最新版-采购订单接口" })
@RestController
@RequestMapping("/uav-po/")
public class UavPOController extends BaseController {
    @Autowired
    private UavPOService uavPOService;

    @ApiOperation(value = "平台确认采购订单（包含签署）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("confirmPOrder")
    private ResultBody confirmPOrder(@RequestBody UavPOConfirmVO uavPOConfirmVO, HttpServletRequest request){
        return uavPOService.confirmPOrder(uavPOConfirmVO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "平台采购订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UavPurchaseOrderDTO.class)})
    @PostMapping("listPurchaseOrder")
    private ResultBody listPurchase(@Validated(Page.class) @RequestBody UavPOrderQO uavPOrderQO, HttpServletRequest request){
        return uavPOService.listPurchase(uavPOrderQO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "订单详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UavPurchaseOrderDTO.class)})
    @GetMapping("getPurchaseOrder")
    private ResultBody getPurchaseOrder(@RequestParam Integer id, HttpServletRequest request) throws Exception {
        return uavPOService.getPurchaseOrder(id, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "上传付款凭证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("upLoadPay")
    public ResultBody upLoadPay(@RequestBody UavOrderPayVO uavOrderPayVO) {
        return uavPOService.upLoadPay(uavOrderPayVO);
    }

    @ApiOperation(value = "审核付款凭证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("checkPay")
    public ResultBody checkPay(@RequestBody UavOrderPayVO uavOrderPayVO) {
        return uavPOService.checkPay(uavOrderPayVO);
    }

    @ApiOperation(value = "发货")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("send")
    public ResultBody send(@RequestBody UavOrderExpressVO param) {
        return uavPOService.send(param);
    }

    @ApiOperation(value = "平台备注")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("userRemark")
    public ResultBody userRemark(@RequestParam Integer id, @RequestParam(required = false) String content) {
        return uavPOService.userRemark(id, content);
    }

    @ApiOperation(value = "商家备注")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("sellerRemark")
    public ResultBody sellerRemark(@RequestParam Integer id, @RequestParam(required = false) String content) {
        return uavPOService.sellerRemark(id, content);
    }
}
