package com.mmc.oms.service.uav.impl;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.oms.common.ResultEnum;
import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.uav.UavCartDao;
import com.mmc.oms.entity.uav.UavCartCompanyDO;
import com.mmc.oms.entity.uav.UavCartDO;
import com.mmc.oms.enums.UavOrderType;
import com.mmc.oms.feign.PmsAppApi;
import com.mmc.oms.model.dto.uav.UavCartCompanyDTO;
import com.mmc.oms.model.dto.uav.UavCartDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.qo.uav.PriceStockQO;
import com.mmc.oms.model.qo.uav.UavCartQO;
import com.mmc.oms.model.vo.uav.UavCartVO;
import com.mmc.oms.service.uav.UavCartService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/9/16 14:40
 */
@Service
@Slf4j
public class UavCartServiceImpl implements UavCartService {
    @Autowired
    private UavCartDao uavCartDao;

    @Autowired
    private PmsAppApi pmsAppApi;

    @Override
    public ResultBody addCart(UavCartVO uavCartVO) {
        UavCartDO uavCartDO = new UavCartDO(uavCartVO);
        uavCartDao.addCart(uavCartDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody batchRemove(List<Integer> carIds) {
        uavCartDao.batchRemove(carIds);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateNum(Integer id, Integer changeNum) {
        UavCartDO uavCartDO = uavCartDao.getUavCartDO(id);
        if (uavCartDO == null) {
            return ResultBody.error(ResultEnum.SHOP_CAR_ERROR);
        }
        // changeNum，正加负减
        Integer targetNum = uavCartDO.getOrderNum() + changeNum;
        if (targetNum.compareTo(0) <= 0) {
            return ResultBody.error(ResultEnum.BUY_NUM_ERROR);
        }
        uavCartDO.setOrderNum(targetNum);
        uavCartDao.updateUavCart(uavCartDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody list(UavCartQO uavCartQO, BaseAccountDTO currentAccount) {
        // 按照第三方企业名称分组查询商品
        List<Integer> list = uavCartDao.countList(currentAccount.getUserAccountId());
        if (list.size() == 0) {
            return ResultBody.success(PageResult.buildPage(uavCartQO.getPageNo(), uavCartQO.getPageSize(), list.size()));
        }
        Integer pageNo = uavCartQO.getPageSize();
        uavCartQO.buildCurrentPage();
        List<UavCartCompanyDO> uavCartCompanyDOS = uavCartDao.list(uavCartQO.getPageNo(), uavCartQO.getPageSize(), currentAccount.getUserAccountId());
        List<UavCartCompanyDTO> uavCartCompanyDTOS = uavCartCompanyDOS.stream().map(UavCartCompanyDO::buildUavCartCompanyDTO).collect(Collectors.toList());
        // 同步商品信息，价格及是否展示
        // 根据规格查询商品信息
        buildUavCartCompany(uavCartQO.getOrderType(), uavCartCompanyDTOS);
        List<UavCartCompanyDTO> collect = uavCartCompanyDTOS.stream().filter(i -> CollectionUtils.isNotEmpty(i.getUavCartDOS())).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, uavCartQO.getPageSize(), list.size(), collect));
    }

    @Override
    public void buildUavCartCompany(Integer orderType, List<UavCartCompanyDTO> uavCartCompanyDTOS){
        List<PriceStockQO> priceStockQOS = new ArrayList<>();
        for (UavCartCompanyDTO uavCartCompanyDTO : uavCartCompanyDTOS) {
            for (UavCartDTO uavCartDO : uavCartCompanyDTO.getUavCartDOS()) {
                PriceStockQO priceStockQO = new PriceStockQO(uavCartDO.getMallGoodsId(), uavCartDO.getProductSpec());
                priceStockQOS.add(priceStockQO);
            }
        }
        // 最新规格信息
        List<UavCartDTO> uavCartDTOS = pmsAppApi.listPriceStock(priceStockQOS);
        if (CollectionUtils.isEmpty(uavCartDTOS)) {
            return;
        }
        // 更新最新的规格信息
        for (UavCartCompanyDTO uavCartCompanyDTO : uavCartCompanyDTOS) {
            uavCartCompanyDTO.setCompanyName(uavCartCompanyDTO.getUavCartDOS().get(0).getCompanyName());
            for (UavCartDTO uavCartDTO : uavCartCompanyDTO.getUavCartDOS()) {
                // 标识是否找到
                Boolean flag = false;
                // 从最新规格中逐个更新，没有则置为失效
                for (UavCartDTO newestUavCartDTO : uavCartDTOS) {
                    if (uavCartDTO.getMallGoodsId().equals(newestUavCartDTO.getMallGoodsId())
                            && uavCartDTO.getProductSpec().equals(newestUavCartDTO.getProductSpec())) {
                        flag = true;
                        uavCartDTO.setPriceShow(newestUavCartDTO.getPriceShow());
                        uavCartDTO.setSalePrice(newestUavCartDTO.getSalePrice());
                        uavCartDTO.setShelfStatus(newestUavCartDTO.getShelfStatus());
                        uavCartDTO.setDeleted(newestUavCartDTO.getDeleted());
                        break;
                    }
                }
                // 找不到或被删除则置为失效
                if (!flag || uavCartDTO.getDeleted().equals(1)) {
                    uavCartDTO.setShelfStatus(0);
                }
            }
            for (UavCartCompanyDTO cartCompanyDTO : uavCartCompanyDTOS) {
                if (UavOrderType.PAY.getCode().equals(orderType)) {
                    cartCompanyDTO.setUavCartDOS(cartCompanyDTO.getUavCartDOS().stream().filter( item -> item.getPriceShow().equals(1)).collect(Collectors.toList()));
                }else {
                    cartCompanyDTO.setUavCartDOS(cartCompanyDTO.getUavCartDOS().stream().filter( item -> item.getPriceShow().equals(0)).collect(Collectors.toList()));
                }
            }
        }
    }
}
