package com.mmc.oms.model.dto.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 15:17
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.mall.dto.CouponUsageDetailsDTO", description = "优惠券使用明细DTO")
public class CouponUsageDetailsDTO {
    private static final long serialVersionUID = 6104334488561632747L;
    @ApiModelProperty("id编号")
    private Integer id;
    @ApiModelProperty("优惠券id")
    private Integer couponId;
    @ApiModelProperty("领劵人id")
    private Integer uid;
    @ApiModelProperty("开始使用时间")
    private Date startTime;
    @ApiModelProperty("优惠券名称")
    private String couponName;
    @ApiModelProperty("状态（0：未使用，1：已使用, 2:已失效，3:已转赠 4:使用中）")
    private Integer status;
    @ApiModelProperty("核销方式 0单次核销 1多次核销")
    private Integer verificationType;
    @ApiModelProperty("关联表id")
    private Integer couponUserId;
    @ApiModelProperty("订单id")
    private String orderId;
    @ApiModelProperty("订单编码")
    private String orderNo;
    @ApiModelProperty("剩余余额")
    private BigDecimal remainingBalance;
    @ApiModelProperty("使用金额")
    private BigDecimal useAmount;
    @ApiModelProperty("优惠券使用时间")
    private Date orderUsageTime;

}

