package com.mmc.oms.model.dto.order;

import com.mmc.oms.model.dto.flyer.FlyerAccountDTO;
import com.mmc.oms.model.dto.flyer.FlyerOrderTaskDTO;
import com.mmc.oms.model.dto.user.UserAccountDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 15:01
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderTaskDTO implements Serializable {
    private static final long serialVersionUID = 6732943573766573605L;
    @ApiModelProperty(value = "订单id")
    private Integer id;
    @ApiModelProperty(value = "主任务id")
    private Integer parentId;
    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;
    @ApiModelProperty(value = "订单专属运营id")
    private Integer userOperateId;
    @ApiModelProperty(value = "用户订单uid")
    private String uid;
    @ApiModelProperty(value = "订单编号")
    private String orderNo;//单号
    @ApiModelProperty(value = "订单名称")
    private String orderName;//名称
    @ApiModelProperty(value = "账单金额")
    private BigDecimal orderAmt;//账单金额
    @ApiModelProperty(value = "订单现金金额")
    private BigDecimal orderCashAmt;
    @ApiModelProperty(value = "订单信用金额")
    private BigDecimal orderCreditAmt;
    @ApiModelProperty(value = "任务状态")
    private Integer orderStatus;//任务状态
    @ApiModelProperty(value = "评价状态")
    private Integer evaluateStatus;//评价状态
    private String lastMsg1;//消息
    private String lastMag2;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "备注")
    private String basicInfo;//基本信息
    @ApiModelProperty(value = "预计开始时间")
    private String startTime;//开始时间
    @ApiModelProperty(value = "预计结束时间")
    private String endTime;//结束时间
    @ApiModelProperty(value = "实际开始时间")
    private String acStartTime;// 实际开始时间
    @ApiModelProperty(value = "实际结束时间")
    private String acEndTime;// 实际结束时间
    @ApiModelProperty(value = "订单地址")
    private String taskAddress;
    private String image;
    @ApiModelProperty(value = "服务id")
    private Integer inspectionId;
    @ApiModelProperty(value = "服务名称")
    private String inspectionName;
    @ApiModelProperty(value = "运营联系电话")
    private String phoneNum;
    @ApiModelProperty(value = "专属运营名称")
    private String operateName;
    @ApiModelProperty(value = "经度")
    private BigDecimal lon;
    @ApiModelProperty(value = "纬度")
    private BigDecimal lat;
    @ApiModelProperty(value = "用户名称")
    private String userName;
    @ApiModelProperty(value = "是否企业")
    private Integer entUser;
    @ApiModelProperty(value = "企业名称")
    private String entName;
    @ApiModelProperty(value = "是否实名")
    private Integer realAuthStatus;
    @ApiModelProperty(value = "昵称")
    private String nickName;
    @ApiModelProperty(value = "订单关闭原因")
    private String shutReason;
    @ApiModelProperty(value = "用户联系电话")
    private String userPhoneNum;
    @ApiModelProperty(value = "飞手Id")
    private Integer flyerAccountId;
    @ApiModelProperty(value = "平台工作人员设置的备注")
    private String pfRemark;
    @ApiModelProperty(value = "飞手端-推送-数据-0否-1是")
    private Integer dummy;
    @ApiModelProperty(value = "飞手UID")
    private String flyerUid;
    @ApiModelProperty(value = "飞手账号名")
    private String flyerAccountName;
    @ApiModelProperty(value = "抢单状态：0待接单,1抢单中")
    private Integer applyStatus;
    @ApiModelProperty(value = "预付款总金额")
    private BigDecimal totalFreeze;
    @ApiModelProperty(value = "结算总金额")
    private BigDecimal totalPay;
    @ApiModelProperty(value = "倒计时")
    private Long countSconds;
    @ApiModelProperty(value = "飞手基本信息")
    private FlyerAccountDTO flyerAccount;
    @ApiModelProperty(value = "飞手类型")
    private Integer flyerType;
    @ApiModelProperty(value = "飞手个数")
    private Integer flyerNum;
    @ApiModelProperty(value = "0:隐藏 1:显示")
    private Integer display;
    @ApiModelProperty(value = "飞手-结算-信息", hidden = true)
    private TaskFlyerCostDTO taskFlyerCost;
    @ApiModelProperty(value = "下期飞手入账时间")
    private String nextFlyerIncomeDate;
    @ApiModelProperty(value = "是否进行过催付款 0：未催 1：已催")
    private Integer urge;
    @ApiModelProperty(value = "订单类型")
    private Integer orderType;
    @ApiModelProperty(value = "确认需求备注")
    private String cmdRemark;
    @ApiModelProperty(value = "飞手可抢单开始时间")
    private Date flyerStartTime;
    @ApiModelProperty(value = "飞手可抢单结束时间")
    private Date flyerEndTime;
    @ApiModelProperty(value = "预估金额")
    private BigDecimal estimatedAmount;
    @ApiModelProperty(value = "申请id")
    private Integer orderApplyId;
    @ApiModelProperty(value = "用户下单附件预览效果")
    private String userPreview;
    @ApiModelProperty(value = "平台上传附件预览效果")
    private String platformPreview;
    @ApiModelProperty(value = "文案描述")
    private String copywriting;
    @ApiModelProperty(value = "子任务列表")
    private List<OrderTaskDTO> children;
    @ApiModelProperty(value = "子订单信息")
    private List<OrderTaskSonDTO> son;

    public void buildOperateUser(UserAccountDTO op) {
        this.phoneNum = op.getPhoneNum();
        this.operateName = op.getUserName();
        this.userOperateId = op.getId();
    }

    public void buildWxUser(UserAccountDTO wx) {
        this.userAccountId = wx.getId();
        this.uid = wx.getUid();
        this.nickName = wx.getNickName();
        this.userName = wx.getUserName();
        this.userPhoneNum = wx.getPhoneNum();
    }

    public FlyerOrderTaskDTO buildFlyerOrderTaskDTO() {
        return FlyerOrderTaskDTO.builder().orderId(this.id).orderNo(this.orderNo).orderName(this.orderName).build();
    }
}
