package com.mmc.oms.controller;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.common.AuthHandler;
import com.mmc.oms.common.BizException;
import com.mmc.oms.common.ResultEnum;
import com.mmc.oms.common.constant.TokenConstant;
import com.mmc.oms.jwt.JwtConstant;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.dto.user.CurrentUserDTO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/5/24 15:58
 * @Version 1.0
 */
public abstract class BaseController {

    @Autowired
    private AuthHandler authHandler;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    /**
     * 获取当前用户
     *
     * @param request
     * @return
     */
    public CurrentUserDTO getCurrentUser(HttpServletRequest request) {
        // 登录未做好-统一通过此方法获取当前用户信息
        Integer id = Integer.parseInt(request.getHeader(JwtConstant.USERIDKEY).toString());
        Integer roleId = Integer.parseInt(request.getHeader(JwtConstant.ROLEIDKEY).toString());
        return CurrentUserDTO.builder().id(id).roleId(roleId).build();
    }

    /**
     * 获取当前登录账号信息
     */
    public BaseAccountDTO getCurrentAccount(HttpServletRequest request) {
        String token = request.getHeader(TokenConstant.TOKEN);
        String json = stringRedisTemplate.opsForValue().get(token);
        if (StringUtils.isBlank(json)) {
            throw new BizException(ResultEnum.LOGIN_ACCOUNT_STATUS_ERROR);
        }
        // 版本问题，需要修改json字符串，去除最外侧""和转义\
        if (json.startsWith("\"") && json.endsWith("\"")) {
            json = json.substring(1, json.length() - 1);
        }
        json = json.replace("\\","");
        BaseAccountDTO baseAccountDTO = JSONObject.parseObject(json, BaseAccountDTO.class);
        return baseAccountDTO;
    }


}
